/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;

class Iteration
extends JPanel {
    protected int untereGrenze;
    protected int i;
    protected int it;
    protected double wert;
    protected double XVersch;
    protected double YVersch;
    protected double XFaktor;
    protected double YFaktor;
    protected Point point1;
    protected Point point2;
    protected double[] vect1;
    protected double[] vect2;
    protected int[] pointsx;
    protected int[] pointsy;
    protected String str;
    protected LogGl Main;
    protected int farbIndex;
    protected int maxFarbIndex = 6;
    protected Color[] Farbe = new Color[]{Color.black, Color.red, Color.blue, Color.green, Color.cyan, Color.magenta};
    protected boolean nopaint;

    public Iteration(LogGl m) {
        this.Main = m;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Iteration.this.mouseClickedHandler(e);
            }
        });
        this.setToolTipText("Zur Eingabe der Startwerte klicken Sie auf die Rechtswertachse (Shift-Klick f\u00fcr numerische Eingabe).");
    }

    protected void CalcFakVersch(JPanel gp) {
        this.XFaktor = 1.0 / (double)(gp.getWidth() - 40);
        this.YFaktor = -1.0 / (double)(gp.getHeight() - 30);
        this.XVersch = -(28.0 * this.XFaktor);
        this.YVersch = 1.0 - 10.0 * this.YFaktor;
    }

    protected Point XyToScreen(double x, double y) {
        Point point = new Point();
        point.x = (int)((x - this.XVersch) / this.XFaktor);
        point.y = (int)((y - this.YVersch) / this.YFaktor);
        return point;
    }

    protected double[] ScreenToXy(int xscreen, int yscreen) {
        double[] v = new double[]{(double)xscreen * this.XFaktor + this.XVersch, (double)yscreen * this.YFaktor + this.YVersch};
        return v;
    }

    public double LogGleichung(double xstart, double par, int it) {
        double fn = xstart;
        for (int i = 0; i < it; ++i) {
            fn = par * fn * (1.0 - fn);
        }
        return fn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mouseClickedHandler(MouseEvent e) {
        if (this.Main.schrittZaehler > 0) {
            return;
        }
        this.point1 = this.XyToScreen(0.0, 0.0);
        if (Math.abs(e.getY() - this.point1.y) > 20) {
            return;
        }
        if (e.isShiftDown()) {
            this.vect1 = this.ScreenToXy(e.getX(), e.getY());
            StartwertEingabe eingabe = new StartwertEingabe((Frame)((JFrame)this.getTopLevelAncestor()), true, this.vect1[0]);
            eingabe.setLocation(e.getX(), e.getY());
            eingabe.showEingabe();
            if (eingabe.canceled) return;
            this.Main.startwerte[this.Main.startwerteAnzahl] = eingabe.wert;
            ++this.Main.startwerteAnzahl;
        } else {
            this.vect1 = this.ScreenToXy(e.getX(), e.getY());
            if (this.vect1[0] < 0.0) {
                this.vect1[0] = 0.0;
            }
            if (this.vect1[0] > 1.0) {
                this.vect1[0] = 1.0;
            }
            this.Main.startwerte[this.Main.startwerteAnzahl] = this.vect1[0];
            ++this.Main.startwerteAnzahl;
        }
        switch (this.Main.buttonLeiste.wieZeichnen) {
            case 2: {
                this.repaint();
                this.Main.zeitserie.repaint();
                return;
            }
            case 1: {
                this.Main.schrittZaehler = 1;
                this.zeichneTrajektorie(this.Main.startwerte[this.Main.startwerteAnzahl - 1], 1);
                try {
                    this.Main.zeitserie.zeichneTrajektorie(this.Main.startwerte[this.Main.startwerteAnzahl - 1], 1);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public void paint(Graphics g) {
        double x;
        if (this.nopaint) {
            return;
        }
        this.CalcFakVersch(this);
        this.untereGrenze = this.getHeight() - 20;
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.black);
        this.point1 = this.XyToScreen(1.0, 0.0);
        this.point2 = this.XyToScreen(0.0, 0.0);
        g.drawLine(this.point1.x + 5, this.untereGrenze, this.point2.x, this.untereGrenze);
        this.point1 = this.XyToScreen(0.0, 1.0);
        g.drawLine(this.point2.x, this.untereGrenze, this.point1.x, this.point1.y - 5);
        for (x = 0.0; x <= 1.0; x += 0.2) {
            this.str = NumberFormat.getInstance().format(x);
            this.point1 = this.XyToScreen(x, 0.0);
            this.point1.y = this.untereGrenze;
            g.drawString(this.str, this.point1.x - 9, this.point1.y + 16);
            g.drawLine(this.point1.x, this.point1.y - 3, this.point1.x, this.point1.y + 6);
        }
        this.wert = 0.0;
        while (this.wert <= 1.0) {
            this.str = NumberFormat.getInstance().format(this.wert);
            this.point1 = this.XyToScreen(0.0, this.wert);
            g.drawString(this.str, this.point1.x - 25, this.point1.y + 5);
            g.drawLine(this.point1.x - 3, this.point1.y, this.point1.x + 6, this.point1.y);
            this.wert += 0.2;
        }
        this.pointsx = new int[50];
        this.pointsy = new int[50];
        this.it = 0;
        while (this.it < 50) {
            this.point1 = this.XyToScreen((double)this.it / 49.0, this.LogGleichung((double)this.it / 49.0, this.Main.mu, 1));
            this.pointsx[this.it] = this.point1.x;
            this.pointsy[this.it] = this.point1.y;
            ++this.it;
        }
        g.drawPolyline(this.pointsx, this.pointsy, 50);
        this.point1 = this.XyToScreen(0.0, 0.0);
        this.point2 = this.XyToScreen(1.0, 1.0);
        g.drawLine(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
        this.farbIndex = 0;
        this.i = 0;
        while (this.i < this.Main.startwerteAnzahl) {
            x = this.Main.startwerte[this.i];
            this.point1 = this.XyToScreen(x, 0.0);
            ++this.farbIndex;
            if (this.farbIndex >= this.maxFarbIndex) {
                this.farbIndex = 0;
            }
            g.setColor(this.Farbe[this.farbIndex]);
            g.fillOval(this.point1.x - 4, this.point1.y - 4, 8, 8);
            this.it = 0;
            while (this.it <= this.Main.maxIterationen) {
                this.wert = this.LogGleichung(x, this.Main.mu, 1);
                this.point2 = this.XyToScreen(x, this.wert);
                g.drawLine(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
                g.fillOval(this.point2.x - 4, this.point2.y - 4, 8, 8);
                if (this.it < this.Main.maxIterationen - 1) {
                    if (this.Main.schrittZaehler > 0 && this.i >= this.Main.startwerteAnzahl - 1 && this.it >= this.Main.schrittZaehler - 2) {
                        return;
                    }
                    this.point1.x = this.point2.x;
                    this.point1.y = this.point2.y;
                    x = this.wert;
                    this.point2 = this.XyToScreen(x, this.wert);
                    g.drawLine(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
                    this.point1.x = this.point2.x;
                    this.point1.y = this.point2.y;
                    Toolkit.getDefaultToolkit().sync();
                }
                ++this.it;
            }
            ++this.i;
        }
    }

    protected void zeichneTrajektorie(double x, int modus) {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        this.point1 = this.XyToScreen(x, 0.0);
        if (this.Main.schrittZaehler <= 1) {
            ++this.farbIndex;
        }
        if (this.farbIndex >= this.maxFarbIndex) {
            this.farbIndex = 0;
        }
        g.setColor(this.Farbe[this.farbIndex]);
        g.fillOval(this.point1.x - 4, this.point1.y - 4, 8, 8);
        if (this.Main.schrittZaehler == 1) {
            return;
        }
        this.it = 0;
        while (this.it <= this.Main.maxIterationen) {
            this.wert = this.LogGleichung(x, this.Main.mu, 1);
            this.point2 = this.XyToScreen(x, this.wert);
            g.drawLine(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
            g.fillOval(this.point2.x - 4, this.point2.y - 4, 8, 8);
            if (this.it == this.Main.maxIterationen - 1) {
                this.Main.schrittZaehler = 0;
                return;
            }
            if (modus == 1 && this.it >= this.Main.schrittZaehler - 2) {
                return;
            }
            this.point1.x = this.point2.x;
            this.point1.y = this.point2.y;
            x = this.wert;
            this.point2 = this.XyToScreen(x, this.wert);
            g.drawLine(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
            this.point1.x = this.point2.x;
            this.point1.y = this.point2.y;
            Toolkit.getDefaultToolkit().sync();
            ++this.it;
        }
    }
}

