/*
 * Decompiled with CFR 0.152.
 */
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;

public class LogGl
extends JFrame
implements Printable {
    protected AboutBox aboutBox;
    protected PrefPane prefs;
    protected Zeitserie zeitserie;
    protected Iteration iteration;
    protected Feigenbaum feigenbaum;
    protected JPanel windowPane;
    protected ButtonLeiste buttonLeiste;
    protected JPanel grafikPane;
    protected boolean compiledForMac = false;
    protected Action aboutAction;
    protected Action quitAction;
    protected Action neuAction;
    protected Action saveAction;
    protected Action pageSetupAction;
    protected Action printAction;
    protected Action iterationAction;
    protected Action zeitserieAction;
    protected Action combiAction;
    protected Action feigenbaumAction;
    static final JMenuBar mainMenuBar = new JMenuBar();
    protected JMenu ablageMenu;
    protected JMenu anzeigeMenu;
    protected JLabel dummyLabel = new JLabel(" ");
    protected PrinterJob printJob = PrinterJob.getPrinterJob();
    protected PageFormat pageFormat;
    public int whatDisplayed;
    public int schrittZaehler;
    public int maxIterationen;
    public int startwerteAnzahl = 0;
    public int startwerteMax = 99;
    public double mu;
    protected double[] startwerte = new double[100];

    public LogGl() {
        super("");
        this.setTitle("Visualisierung der Logistischen Gleichung");
        this.windowPane = (JPanel)this.getContentPane();
        this.aboutBox = new AboutBox();
        this.createActions();
        this.addMenus();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(1);
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            public void eventDispatched(AWTEvent event) {
                LogGl.this.keyEventHandler((KeyEvent)event);
            }
        }, 8L);
        this.buttonLeiste = new ButtonLeiste(this);
        this.zeitserie = new Zeitserie(this);
        this.iteration = new Iteration(this);
        this.feigenbaum = new Feigenbaum(this);
        this.grafikPane = new JPanel(new GridLayout(1, 1));
        this.grafikPane.setMinimumSize(new Dimension(600, 400));
        this.grafikPane.setBorder(new BevelBorder(1, Color.darkGray, Color.lightGray, Color.darkGray, Color.lightGray));
        this.grafikPane.setBackground(Color.white);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screenSize.width, screenSize.height);
        this.setResizable(true);
        this.setVisible(true);
        this.mu = this.buttonLeiste.mu;
        this.maxIterationen = this.buttonLeiste.maxIterationen;
        this.whatDisplayed = 2;
        this.grafikPane.add(this.iteration);
        this.windowPane.setLayout(new BorderLayout());
        this.windowPane.add((Component)this.buttonLeiste, "North");
        this.windowPane.add((Component)this.grafikPane, "Center");
        this.show();
    }

    public void createActions() {
        int shortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.aboutAction = new aboutActionClass("\u00dcber LogGl", null);
        this.quitAction = new quitActionClass("Programm beenden", KeyStroke.getKeyStroke(81, shortcutKeyMask));
        this.neuAction = new neuActionClass("Neu", KeyStroke.getKeyStroke(78, shortcutKeyMask));
        this.saveAction = new saveActionClass("Bild speichern...", KeyStroke.getKeyStroke(83, shortcutKeyMask));
        this.pageSetupAction = new pageSetupActionClass("Papierformat...", KeyStroke.getKeyStroke(80, 5));
        this.printAction = new printActionClass("Drucken...", KeyStroke.getKeyStroke(80, shortcutKeyMask));
        this.iterationAction = new iterationActionClass("Iteration", KeyStroke.getKeyStroke(73, shortcutKeyMask));
        this.zeitserieAction = new zeitserieActionClass("Zeitserie", KeyStroke.getKeyStroke(90, shortcutKeyMask));
        this.combiAction = new combiActionClass("Kombination", KeyStroke.getKeyStroke(75, shortcutKeyMask));
        this.feigenbaumAction = new feigenbaumActionClass("Feigenbaum", KeyStroke.getKeyStroke(70, shortcutKeyMask));
    }

    public void addMenus() {
        mainMenuBar.removeAll();
        this.ablageMenu = this.compiledForMac ? new JMenu("Ablage") : new JMenu("Datei");
        this.ablageMenu.add(new JMenuItem(this.neuAction));
        this.ablageMenu.addSeparator();
        this.ablageMenu.add(new JMenuItem(this.saveAction));
        this.ablageMenu.addSeparator();
        this.ablageMenu.add(new JMenuItem(this.pageSetupAction));
        this.ablageMenu.add(new JMenuItem(this.printAction));
        if (!this.compiledForMac) {
            this.ablageMenu.addSeparator();
            this.ablageMenu.add(new JMenuItem(this.quitAction));
        }
        mainMenuBar.add(this.ablageMenu);
        this.anzeigeMenu = new JMenu("Anzeige");
        this.anzeigeMenu.add(new JMenuItem(this.iterationAction));
        this.anzeigeMenu.add(new JMenuItem(this.zeitserieAction));
        this.anzeigeMenu.add(new JMenuItem(this.combiAction));
        this.anzeigeMenu.addSeparator();
        this.anzeigeMenu.add(new JMenuItem(this.feigenbaumAction));
        if (!this.compiledForMac) {
            this.anzeigeMenu.addSeparator();
            this.anzeigeMenu.add(new JMenuItem(this.aboutAction));
        }
        mainMenuBar.add(this.anzeigeMenu);
        this.setJMenuBar(mainMenuBar);
    }

    public void doPrint() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        PrintJob pj = tk.getPrintJob(new Frame(), "Drucken is toll!", null);
        if (pj != null) {
            this.printJob.setPrintable(this, this.pageFormat);
            if (this.printJob.printDialog()) {
                try {
                    this.printJob.print();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void keyEventHandler(KeyEvent event) {
        if (event.getID() == 401) {
            if (event.getKeyCode() == 32) {
                event.consume();
                if (this.schrittZaehler > 0 && this.startwerteAnzahl > 0) {
                    if (this.schrittZaehler > 0) {
                        ++this.schrittZaehler;
                    }
                    this.iteration.zeichneTrajektorie(this.startwerte[this.startwerteAnzahl - 1], 1);
                    this.zeitserie.zeichneTrajektorie(this.startwerte[this.startwerteAnzahl - 1], 1);
                }
            }
        }
        if (event.getID() == 401) {
            if (event.getKeyCode() == 10) {
                this.schrittZaehler = 0;
                this.repaint();
            }
        }
        if (event.getID() == 401) {
            if (event.getKeyCode() == 27) {
                this.feigenbaum.x1 = -1;
                this.repaint();
            }
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        this.grafikPane.paint(g);
        return 0;
    }

    public static void main(String[] args) {
        new LogGl();
    }

    public class feigenbaumActionClass
    extends AbstractAction {
        public feigenbaumActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            LogGl.this.setTitle("Feigenbaumdarstellung der Logistischen Gleichung");
            LogGl.this.buttonLeiste.addFBComponents();
            LogGl.this.grafikPane.removeAll();
            LogGl.this.grafikPane.add(LogGl.this.feigenbaum);
            LogGl.this.show();
            LogGl.this.whatDisplayed = 4;
            LogGl.this.windowPane.repaint();
            if (LogGl.this.feigenbaum.calcFeigenbaum == null) {
                LogGl.this.feigenbaum.berechne();
            }
        }
    }

    public class combiActionClass
    extends AbstractAction {
        public combiActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            LogGl.this.setTitle("Visualisierung der Logistischen Gleichung");
            LogGl.this.buttonLeiste.addZsItComponents();
            LogGl.this.grafikPane.removeAll();
            LogGl.this.grafikPane.add(LogGl.this.iteration);
            LogGl.this.grafikPane.add(LogGl.this.zeitserie);
            LogGl.this.show();
            LogGl.this.buttonLeiste.muSlider.setValue((int)(LogGl.this.mu * 100.0));
            if (LogGl.this.whatDisplayed == 4) {
                LogGl.this.schrittZaehler = 0;
            }
            LogGl.this.whatDisplayed = 3;
            LogGl.this.windowPane.repaint();
        }
    }

    public class zeitserieActionClass
    extends AbstractAction {
        public zeitserieActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            LogGl.this.setTitle("Visualisierung der Logistischen Gleichung");
            LogGl.this.buttonLeiste.addZsItComponents();
            LogGl.this.grafikPane.removeAll();
            LogGl.this.grafikPane.add(LogGl.this.zeitserie);
            LogGl.this.show();
            LogGl.this.buttonLeiste.muSlider.setValue((int)(LogGl.this.mu * 100.0));
            if (LogGl.this.whatDisplayed == 4) {
                LogGl.this.schrittZaehler = 0;
            }
            LogGl.this.whatDisplayed = 1;
            LogGl.this.windowPane.repaint();
        }
    }

    public class iterationActionClass
    extends AbstractAction {
        public iterationActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            LogGl.this.setTitle("Visualisierung der Logistischen Gleichung");
            LogGl.this.buttonLeiste.addZsItComponents();
            LogGl.this.grafikPane.removeAll();
            LogGl.this.grafikPane.add(LogGl.this.iteration);
            LogGl.this.buttonLeiste.muSlider.setValue((int)(LogGl.this.mu * 100.0));
            if (LogGl.this.whatDisplayed == 4) {
                LogGl.this.schrittZaehler = 0;
            }
            LogGl.this.whatDisplayed = 2;
            LogGl.this.show();
            LogGl.this.windowPane.repaint();
        }
    }

    public class aboutActionClass
    extends AbstractAction {
        public aboutActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            LogGl.this.aboutBox.setVisible(true);
            LogGl.this.aboutBox.show();
        }
    }

    public class quitActionClass
    extends AbstractAction {
        public quitActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    public class printActionClass
    extends AbstractAction {
        public printActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            LogGl.this.doPrint();
        }
    }

    public class pageSetupActionClass
    extends AbstractAction {
        public pageSetupActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            LogGl.this.pageFormat = LogGl.this.printJob.pageDialog(LogGl.this.printJob.defaultPage());
            LogGl.this.printJob.defaultPage(LogGl.this.pageFormat);
        }
    }

    public class saveActionClass
    extends AbstractAction {
        public saveActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            FileDialog fileSaveDialog = new FileDialog((Frame)((JFrame)LogGl.this.grafikPane.getTopLevelAncestor()), "Geben Sie Name und Ort der Bilddatei an...", 1);
            fileSaveDialog.setFile("LogGlPic.jpg");
            fileSaveDialog.show();
            if (fileSaveDialog.getFile() != null) {
                try {
                    File file = new File(fileSaveDialog.getDirectory(), fileSaveDialog.getFile());
                    FileOutputStream out = new FileOutputStream(file);
                    BufferedImage bild = new BufferedImage(LogGl.this.grafikPane.getWidth(), LogGl.this.grafikPane.getHeight(), 1);
                    Graphics2D gra = bild.createGraphics();
                    LogGl.this.grafikPane.paint(gra);
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                    JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bild);
                    param.setQuality(0.9f, true);
                    encoder.encode(bild, param);
                    out.close();
                }
                catch (Exception ex) {
                    new AutoDialog().display("Fehler!", "Kann die Datei nicht schreiben.");
                }
            }
        }
    }

    public class neuActionClass
    extends AbstractAction {
        public neuActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            if (LogGl.this.whatDisplayed == 4) {
                LogGl.this.feigenbaum.initialisiere();
                LogGl.this.feigenbaum.berechne();
            } else {
                LogGl.this.buttonLeiste.neuButton_actionPerformed(e);
            }
        }
    }
}

