/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ButtonLeiste
extends JPanel {
    Magnetpendel Main;
    private ButtonGroup buttonGroup1;
    private JTextField gravField;
    private JLabel gravLabel;
    private JSlider gravSlider;
    private JButton neuButton;
    private JButton parameterButton;
    private JTextField reibField;
    private JLabel reibLabel;
    private JSlider reibSlider;
    private JLabel sep1;
    private JLabel sep3;
    private JLabel sep5;

    public ButtonLeiste(Magnetpendel m) {
        this.Main = m;
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.reibLabel = new JLabel();
        this.reibSlider = new JSlider();
        this.reibField = new JTextField();
        this.sep1 = new JLabel();
        this.gravLabel = new JLabel();
        this.gravSlider = new JSlider();
        this.gravField = new JTextField();
        this.sep3 = new JLabel();
        this.parameterButton = new JButton();
        this.sep5 = new JLabel();
        this.neuButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.reibLabel.setText("D\u00e4mpfung:");
        this.add((Component)this.reibLabel, new GridBagConstraints());
        this.reibSlider.setMajorTickSpacing(100);
        this.reibSlider.setMaximum(1010);
        this.reibSlider.setMinimum(10);
        this.reibSlider.setMinorTickSpacing(25);
        this.reibSlider.setPaintTicks(true);
        this.reibSlider.setToolTipText("Einstellen der D\u00e4mpfung im Bereich von 0,01 bis 1,01.");
        this.reibSlider.setValue(250);
        this.reibSlider.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.reibSlider.setMinimumSize(new Dimension(100, 30));
        this.reibSlider.setPreferredSize(new Dimension(140, 30));
        this.reibSlider.setValueIsAdjusting(true);
        this.reibSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ButtonLeiste.this.reibSliderStateChangedHandler(evt);
            }
        });
        this.add((Component)this.reibSlider, new GridBagConstraints());
        this.reibField.setText("0,25");
        this.reibField.setToolTipText("Numerische Eingabe des Wertes f\u00fcr \u00b5.");
        this.reibField.setMinimumSize(new Dimension(35, 20));
        this.reibField.setPreferredSize(new Dimension(60, 20));
        this.reibField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonLeiste.this.reibFieldActionPerformed(evt);
            }
        });
        this.add((Component)this.reibField, new GridBagConstraints());
        this.sep1.setMinimumSize(new Dimension(10, 5));
        this.sep1.setPreferredSize(new Dimension(30, 20));
        this.add((Component)this.sep1, new GridBagConstraints());
        this.gravLabel.setText("Gravitation:");
        this.add((Component)this.gravLabel, new GridBagConstraints());
        this.gravSlider.setMajorTickSpacing(100);
        this.gravSlider.setMaximum(1000);
        this.gravSlider.setMinorTickSpacing(25);
        this.gravSlider.setPaintTicks(true);
        this.gravSlider.setToolTipText("Einstellen der Gravitation im Bereich von 0 bis 1.");
        this.gravSlider.setValue(300);
        this.gravSlider.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.gravSlider.setMinimumSize(new Dimension(100, 30));
        this.gravSlider.setPreferredSize(new Dimension(140, 30));
        this.gravSlider.setValueIsAdjusting(true);
        this.gravSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ButtonLeiste.this.gravSliderStateChanged(evt);
            }
        });
        this.gravSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ButtonLeiste.this.gravSliderMouseReleased(evt);
            }
        });
        this.add((Component)this.gravSlider, new GridBagConstraints());
        this.gravField.setText("0,3");
        this.gravField.setToolTipText("Numerische Eingabe des Wertes f\u00fcr \u00b5.");
        this.gravField.setMinimumSize(new Dimension(35, 20));
        this.gravField.setPreferredSize(new Dimension(60, 20));
        this.gravField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonLeiste.this.gravFieldActionPerformed(evt);
            }
        });
        this.add((Component)this.gravField, new GridBagConstraints());
        this.sep3.setMinimumSize(new Dimension(10, 5));
        this.sep3.setPreferredSize(new Dimension(25, 5));
        this.add((Component)this.sep3, new GridBagConstraints());
        this.parameterButton.setText("Parameter");
        this.parameterButton.setToolTipText("EIngabe weiterer Parameter.");
        this.parameterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonLeiste.this.parameterButtonActionPerformed(evt);
            }
        });
        this.add((Component)this.parameterButton, new GridBagConstraints());
        this.sep5.setMinimumSize(new Dimension(10, 5));
        this.sep5.setPreferredSize(new Dimension(20, 49));
        this.add((Component)this.sep5, new GridBagConstraints());
        this.neuButton.setText("l\u00f6schen");
        this.neuButton.setToolTipText("Alle eingegebenen Startwerte werden gel\u00f6scht.");
        this.neuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonLeiste.this.neuButtonActionPerformed(evt);
            }
        });
        this.add((Component)this.neuButton, new GridBagConstraints());
    }

    private void parameterButtonActionPerformed(ActionEvent evt) {
        ParameterEingabe eingabe = new ParameterEingabe((JFrame)this.Main.trajektorie.getTopLevelAncestor(), true);
        eingabe.setValues(this.Main.trajektorie.XMin, this.Main.trajektorie.XMax, this.Main.trajektorie.YMin, this.Main.trajektorie.YMax, this.Main.trajektorie.ReibKoeff, this.Main.trajektorie.GravConst, this.Main.trajektorie.MagAbst, this.Main.trajektorie.Genauigkeit, this.Main.trajektorie.AnfangsSchrittweite, this.Main.trajektorie.MagEntf, this.Main.trajektorie.MagAnz, this.Main.trajektorie.MagX, this.Main.trajektorie.MagY, this.Main.trajektorie.MagPar, this.Main.trajektorie.MagnetFarben);
        eingabe.show();
        if (eingabe.okButtonPressed) {
            this.Main.trajektorie.XMin = eingabe.xmin;
            this.Main.trajektorie.XMax = eingabe.xmax;
            this.Main.trajektorie.YMin = eingabe.ymin;
            this.Main.trajektorie.YMax = eingabe.ymax;
            this.Main.trajektorie.ReibKoeff = eingabe.reibKoeff;
            this.Main.trajektorie.GravConst = eingabe.gravKonst;
            this.update();
            this.Main.trajektorie.MagAbst = eingabe.magAbst;
            this.Main.trajektorie.Genauigkeit = eingabe.genauigkeit;
            this.Main.trajektorie.AnfangsSchrittweite = eingabe.schrittweite;
            this.Main.trajektorie.MagEntf = eingabe.endeEntf;
            if (eingabe.magnetsChanged) {
                int i;
                for (i = 0; i < 3; ++i) {
                    this.Main.trajektorie.MagAnz = eingabe.magAnz;
                }
                for (i = 0; i < 3; ++i) {
                    this.Main.trajektorie.MagX[i] = eingabe.magX[i];
                }
                for (i = 0; i < 3; ++i) {
                    this.Main.trajektorie.MagY[i] = eingabe.magY[i];
                }
                for (i = 0; i < 3; ++i) {
                    this.Main.trajektorie.MagPar[i] = eingabe.magSt[i];
                }
                for (i = 0; i < 4; ++i) {
                    this.Main.trajektorie.MagnetFarben[i] = eingabe.magFarbe[i];
                }
            }
            this.Main.trajektorie.CalcBackground(this.Main.trajektorie.hintergrundBild, this);
            this.Main.trajektorie.repaint();
        }
    }

    private void neuButtonActionPerformed(ActionEvent evt) {
        this.Main.trajektorie.startwerteAnzahl = 0;
        this.Main.trajektorie.repaint();
    }

    private void gravSliderMouseReleased(MouseEvent evt) {
        this.Main.trajektorie.CalcBackground(this.Main.trajektorie.hintergrundBild, this);
    }

    private void gravSliderStateChanged(ChangeEvent evt) {
        this.Main.trajektorie.GravConst = (double)this.gravSlider.getValue() / 1000.0;
        this.gravField.setText(NumberFormat.getInstance().format(this.Main.trajektorie.GravConst));
        this.Main.trajektorie.trajektorienNeu();
    }

    private void gravFieldActionPerformed(ActionEvent evt) {
        this.readTextFields();
        this.gravSlider.setValue((int)(this.Main.trajektorie.GravConst * 1000.0));
        this.Main.trajektorie.CalcBackground(this.Main.trajektorie.hintergrundBild, this);
    }

    private void reibFieldActionPerformed(ActionEvent evt) {
        this.readTextFields();
        this.reibSlider.setValue((int)(this.Main.trajektorie.ReibKoeff * 1000.0));
    }

    private void reibSliderStateChangedHandler(ChangeEvent evt) {
        this.Main.trajektorie.ReibKoeff = (double)this.reibSlider.getValue() / 1000.0;
        this.reibField.setText(NumberFormat.getInstance().format(this.Main.trajektorie.ReibKoeff));
        this.Main.trajektorie.trajektorienNeu();
    }

    void readTextFields() {
        try {
            this.Main.trajektorie.ReibKoeff = NumberFormat.getInstance().parse(this.reibField.getText()).doubleValue();
            this.Main.trajektorie.GravConst = NumberFormat.getInstance().parse(this.gravField.getText()).doubleValue();
        }
        catch (ParseException e) {
            new AutoDialog().display("Fehler bein Einlesen der Zahlenwerte.", "Es sind nicht erlaubte Zeichen vorhanden!", "OK");
        }
    }

    public void update() {
        this.reibSlider.setValue((int)(this.Main.trajektorie.ReibKoeff * 1000.0));
        this.gravSlider.setValue((int)(this.Main.trajektorie.GravConst * 1000.0));
    }
}

