/*
 * Decompiled with CFR 0.152.
 */
public class RungeKutta {
    final int SMAX = 16;
    final int DMAX = 7;
    final int NVARMAX = 4;
    long ngood;
    long nfail;
    int s;
    int ss;
    int q;
    int p;
    int d;
    boolean fsal;
    double[][] a = new double[16][15];
    double[] b = new double[16];
    double[] bdach = new double[16];
    double[] berr = new double[16];
    double[] c = new double[16];
    double[][] beta = new double[8][16];
    double potenz;
    double eps;
    double tend;
    int nvar;
    boolean autonom;
    boolean neu;
    double[][] k = new double[16][4];
    double h0;
    double tt;
    double[] ybeg = new double[4];
    double Schrittweite;
    double tlast = 1.0E13;
    Trajektorie parent;
    double[] ys = new double[4];
    double[] ytemp = new double[4];
    double[][] aa = new double[8][4];

    public RungeKutta(Trajektorie p) {
        this.parent = p;
        this.rkcoeff();
    }

    void error(String s) {
        System.out.println("ERROR : " + s);
    }

    double max(double x1, double x2) {
        return x1 > x2 ? x1 : x2;
    }

    void rkcoeff() {
        int j;
        int i;
        for (i = 0; i < 16; ++i) {
            this.b[i] = 0.0;
            this.bdach[i] = 0.0;
            this.berr[i] = 0.0;
            this.c[i] = 0.0;
            for (j = 0; j < 15; ++j) {
                this.a[i][j] = 0.0;
            }
            for (j = 0; j < 8; ++j) {
                this.beta[j][i] = 0.0;
            }
        }
        this.q = 5;
        this.p = 4;
        this.s = 7;
        this.ss = 7;
        this.d = 5;
        this.fsal = true;
        this.a[1][0] = 0.2;
        this.a[2][0] = 0.075;
        this.a[2][1] = 0.225;
        this.a[3][0] = 0.9777777777777777;
        this.a[3][1] = -3.7333333333333334;
        this.a[3][2] = 3.5555555555555554;
        this.a[4][0] = 2.9525986892242035;
        this.a[4][1] = -11.595793324188385;
        this.a[4][2] = 9.822892851699436;
        this.a[4][3] = -0.2908093278463649;
        this.a[5][0] = 2.8462752525252526;
        this.a[5][1] = -10.757575757575758;
        this.a[5][2] = 8.906422717743473;
        this.a[5][3] = 0.2784090909090909;
        this.a[5][4] = -0.2735313036020583;
        this.a[6][0] = 0.09114583333333333;
        this.a[6][2] = 0.44923629829290207;
        this.a[6][3] = 0.6510416666666666;
        this.a[6][4] = -0.322376179245283;
        this.a[6][5] = 0.13095238095238096;
        this.b[0] = 0.09114583333333333;
        this.b[2] = 0.44923629829290207;
        this.b[3] = 0.6510416666666666;
        this.b[4] = -0.322376179245283;
        this.b[5] = 0.13095238095238096;
        this.bdach[0] = 0.08991319444444444;
        this.bdach[2] = 0.4534890685834082;
        this.bdach[3] = 0.6140625;
        this.bdach[4] = -0.2715123820754717;
        this.bdach[5] = 0.08904761904761904;
        this.bdach[6] = 0.025;
        this.beta[0][0] = 1.0;
        this.beta[1][0] = -2.8605386690370884;
        this.beta[2][0] = 3.099577878709121;
        this.beta[3][0] = -1.1618105836403092;
        this.beta[4][0] = 0.013917207301610328;
        this.beta[1][2] = 4.047141499642786;
        this.beta[2][2] = -6.345354046938926;
        this.beta[3][2] = 2.795465086414005;
        this.beta[4][2] = -0.04801624082496286;
        this.beta[1][3] = -3.941160071112659;
        this.beta[2][3] = 10.904003027940295;
        this.beta[3][3] = -6.729317509209278;
        this.beta[4][3] = 0.4175162190483098;
        this.beta[1][4] = 2.8419447015870345;
        this.beta[2][4] = -7.547675862959386;
        this.beta[3][4] = 4.957636724931253;
        this.beta[4][4] = -0.5742817428041846;
        this.beta[1][5] = -1.6109886359167997;
        this.beta[2][5] = 4.218915839039518;
        this.beta[3][5] = -2.950103865566732;
        this.beta[4][5] = 0.47312904339639456;
        this.beta[1][6] = 1.523601174836727;
        this.beta[2][6] = -4.329466835790622;
        this.beta[3][6] = 3.0881301470710616;
        this.beta[4][6] = -0.2822644861171672;
        for (i = 0; i < this.ss; ++i) {
            for (j = 0; j < i; ++j) {
                int n = i;
                this.c[n] = this.c[n] + this.a[i][j];
            }
        }
        for (i = 0; i < this.s; ++i) {
            this.berr[i] = this.bdach[i] - this.b[i];
        }
        this.potenz = 1.0 / ((double)this.p + 1.0);
    }

    void rkinit(boolean autonom_p, int nvar_p, double eps_p, double tend_p, double h_p) {
        this.eps = eps_p;
        this.nvar = nvar_p;
        this.tend = tend_p;
        this.autonom = autonom_p;
        if (Math.abs(h_p) >= 9.9E-324) {
            this.Schrittweite = h_p;
        }
    }

    double[] rkstep(double t, double[] y) {
        boolean fail;
        int i;
        double[] yneu = new double[5];
        double[] ytemp = new double[4];
        double ttemp = 0.0;
        int ifail = 0;
        this.tt = t;
        if (!this.fsal || Math.abs(t - this.tlast) > 9.9E-324) {
            this.k[0] = this.parent.dgl(t, y);
        } else {
            for (i = 0; i < this.nvar; ++i) {
                this.k[0][i] = this.k[this.s - 1][i];
            }
        }
        do {
            double hfakt;
            int l;
            if (t + this.Schrittweite > this.tend) {
                this.Schrittweite = this.tend - t;
            }
            for (i = 1; i < this.s; ++i) {
                for (l = 0; l < this.nvar; ++l) {
                    ytemp[l] = 0.0;
                    for (int j = 0; j < i; ++j) {
                        int n = l;
                        ytemp[n] = ytemp[n] + this.a[i][j] * this.k[j][l];
                    }
                    ytemp[l] = y[l] + this.Schrittweite * ytemp[l];
                }
                if (!this.autonom) {
                    ttemp = t + this.c[i] * this.Schrittweite;
                }
                this.k[i] = this.parent.dgl(ttemp, ytemp);
            }
            double err = 0.0;
            for (l = 0; l < this.nvar; ++l) {
                double ydiff = 0.0;
                yneu[l] = 0.0;
                for (i = 0; i < this.s; ++i) {
                    int n = l;
                    yneu[n] = yneu[n] + this.b[i] * this.k[i][l];
                    ydiff += this.berr[i] * this.k[i][l];
                }
                ydiff = Math.abs(this.Schrittweite * ydiff);
                err = this.max(err, ydiff);
                yneu[l] = y[l] + this.Schrittweite * yneu[l];
            }
            fail = err > this.eps;
            if (fail) {
                ++ifail;
            }
            if (ifail > 5) {
                this.error("Schrittweite 5 mal erfolglos verkleinert");
            }
            if ((hfakt = 0.9 * Math.pow(this.eps / err, this.potenz)) < 0.1) {
                hfakt = 0.1;
            }
            if (hfakt > 5.0) {
                hfakt = 5.0;
            }
            this.h0 = this.Schrittweite;
            if (ifail != 0 && !(hfakt < 1.0)) continue;
            this.Schrittweite *= hfakt;
        } while (fail);
        this.nfail += (long)ifail;
        ++this.ngood;
        for (i = 0; i < this.nvar; ++i) {
            this.ybeg = y;
        }
        this.neu = true;
        yneu[4] = this.tlast = t + this.h0;
        return yneu;
    }

    double[] rkipol(double ts) {
        double sigma;
        int l;
        int i;
        double ttemp = 0.0;
        if (this.neu) {
            int j;
            for (i = this.s; i < this.ss; ++i) {
                for (l = 0; l < this.nvar; ++l) {
                    this.ytemp[l] = 0.0;
                    for (j = 0; j < i; ++j) {
                        int n = l;
                        this.ytemp[n] = this.ytemp[n] + this.a[i][j] * this.k[j][l];
                    }
                    this.ytemp[l] = this.ybeg[l] + this.h0 * this.ytemp[l];
                }
                if (!this.autonom) {
                    ttemp = this.tt + this.c[i] * this.h0;
                }
                this.k[i] = this.parent.dgl(ttemp, this.ytemp);
            }
            for (l = 0; l < this.nvar; ++l) {
                this.aa[0][l] = this.ybeg[l];
                for (j = 1; j <= this.d; ++j) {
                    this.aa[j][l] = 0.0;
                    for (i = 0; i < this.ss; ++i) {
                        double[] dArray = this.aa[j];
                        int n = l;
                        dArray[n] = dArray[n] + this.beta[j - 1][i] * this.k[i][l];
                    }
                    double[] dArray = this.aa[j];
                    int n = l;
                    dArray[n] = dArray[n] * this.h0;
                }
            }
            this.neu = false;
        }
        if ((sigma = (ts - this.tt) / this.h0) < 0.0 || sigma > 1.0) {
            this.error("sigma au\u00dferhalb Bereich 0...1");
        }
        for (l = 0; l < this.nvar; ++l) {
            this.ys[l] = this.aa[this.d][l];
            for (i = this.d - 1; i >= 0; --i) {
                this.ys[l] = this.ys[l] * sigma + this.aa[i][l];
            }
        }
        return this.ys;
    }
}

