/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.djep;

import com.singularsys.extensions.djep.DJep;
import com.singularsys.extensions.djep.PartialDerivative;
import com.singularsys.extensions.xjep.XVariable;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.PrintVisitor;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.Node;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DVariable
extends XVariable {
    private static final long serialVersionUID = 1100L;
    protected Map<String, PartialDerivative> derivatives = new HashMap<String, PartialDerivative>();

    protected PartialDerivative createDerivative(String[] stringArray, Node node) {
        return new PartialDerivative(this, stringArray, node);
    }

    protected DVariable(String string) {
        super(string);
    }

    protected DVariable(String string, Object object) {
        super(string, object);
    }

    @Override
    public void setEquation(Node node) {
        super.setEquation(node);
        this.derivatives.clear();
    }

    public void invalidateAll() {
        if (this.isConstant()) {
            return;
        }
        this.setValidValue(false);
        for (Map.Entry<String, PartialDerivative> entry : this.derivatives.entrySet()) {
            PartialDerivative partialDerivative = entry.getValue();
            partialDerivative.setValidValue(false);
        }
    }

    public static String makeDerivString(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('d');
        if (stringArray.length != 1) {
            stringBuffer.append("^" + stringArray.length);
        }
        stringBuffer.append(string);
        stringBuffer.append('/');
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append('d');
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private String[] sortedNames(String[] stringArray) {
        Object[] objectArray = new String[stringArray.length];
        System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
        Arrays.sort(objectArray);
        return objectArray;
    }

    void setDerivative(String[] stringArray, PartialDerivative partialDerivative) {
        String[] stringArray2 = this.sortedNames(stringArray);
        this.derivatives.put(DVariable.makeDerivString(this.name, stringArray2), partialDerivative);
    }

    void setDerivativeSorted(String[] stringArray, PartialDerivative partialDerivative) {
        this.derivatives.put(DVariable.makeDerivString(this.name, stringArray), partialDerivative);
    }

    PartialDerivative getDerivative(String[] stringArray) {
        String[] stringArray2 = this.sortedNames(stringArray);
        return this.derivatives.get(DVariable.makeDerivString(this.name, stringArray2));
    }

    PartialDerivative getDerivativeSorted(String[] stringArray) {
        return this.derivatives.get(DVariable.makeDerivString(this.name, stringArray));
    }

    PartialDerivative findDerivativeSorted(String[] stringArray, DJep dJep) throws ParseException {
        if (stringArray == null) {
            throw new ParseException("findDerivativeSorted: Null array of names");
        }
        PartialDerivative partialDerivative = this.getDerivativeSorted(stringArray);
        if (partialDerivative != null) {
            return partialDerivative;
        }
        partialDerivative = this.calculateDerivative(stringArray, dJep);
        this.setDerivative(stringArray, partialDerivative);
        return partialDerivative;
    }

    protected PartialDerivative calculateDerivative(String[] stringArray, DJep dJep) throws ParseException {
        Object object;
        Node node;
        int n = stringArray.length;
        if (n < 1) {
            throw new ParseException("findDerivativeSorted: Empty Array of names");
        }
        if (n == 1) {
            node = this.getEquation();
        } else {
            object = new String[n - 1];
            for (int i = 0; i < n - 1; ++i) {
                object[i] = stringArray[i];
            }
            node = this.findDerivativeSorted((String[])object, dJep).getEquation();
        }
        if (node == null) {
            return null;
        }
        object = dJep.differentiate(node, stringArray[n - 1]);
        Node node2 = dJep.clean((Node)object);
        PartialDerivative partialDerivative = this.createDerivative(stringArray, node2);
        return partialDerivative;
    }

    PartialDerivative findDerivative(String[] stringArray, DJep dJep) throws ParseException {
        String[] stringArray2 = this.sortedNames(stringArray);
        return this.findDerivativeSorted(stringArray2, dJep);
    }

    PartialDerivative findDerivative(String string, DJep dJep) throws ParseException {
        String[] stringArray = new String[]{string};
        return this.findDerivativeSorted(stringArray, dJep);
    }

    PartialDerivative findDerivative(PartialDerivative partialDerivative, String string, DJep dJep) throws ParseException {
        int n = partialDerivative.getDnames().length;
        String[] stringArray = new String[n + 1];
        System.arraycopy(partialDerivative.getDnames(), 0, stringArray, 0, n);
        stringArray[n] = string;
        return this.findDerivative(stringArray, dJep);
    }

    @Override
    public String toString(PrintVisitor printVisitor) {
        boolean bl = printVisitor.getMode(32);
        printVisitor.setMode(32, false);
        StringBuffer stringBuffer = new StringBuffer(this.name);
        stringBuffer.append(":\t");
        if (this.hasValidValue()) {
            stringBuffer.append(this.getValue());
        } else {
            stringBuffer.append("NA");
        }
        stringBuffer.append("\t");
        if (this.isConstant()) {
            stringBuffer.append("constant");
        } else if (this.getEquation() != null) {
            stringBuffer.append("eqn " + printVisitor.toString(this.getEquation()));
        } else {
            stringBuffer.append("no equation");
        }
        for (Map.Entry<String, PartialDerivative> entry : this.derivatives.entrySet()) {
            stringBuffer.append("\n");
            PartialDerivative partialDerivative = entry.getValue();
            stringBuffer.append("\t" + partialDerivative.toString() + ": ");
            if (partialDerivative.hasValidValue()) {
                stringBuffer.append(partialDerivative.getValue());
            } else {
                stringBuffer.append("NA");
            }
            stringBuffer.append("\t");
            if (!partialDerivative.hasEquation()) continue;
            stringBuffer.append(printVisitor.toString(partialDerivative.getEquation()));
        }
        printVisitor.setMode(32, bl);
        return stringBuffer.toString();
    }

    public Iterable<PartialDerivative> allDerivatives() {
        return this.derivatives.values();
    }

    public boolean derivativeIsTrivallyZero() {
        if (!this.hasEquation()) {
            return true;
        }
        return this.getEquation() instanceof ASTConstant;
    }
}

