/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.djep.diffRules;

import com.singularsys.extensions.djep.DJep;
import com.singularsys.extensions.djep.DiffRulesI;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.Operator;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.Node;

public class ZeroDiffRule
implements DiffRulesI {
    private static final long serialVersionUID = 340L;
    private final String name;
    private final PostfixMathCommandI pfmc;
    private NodeFactory nf;
    Object zero;

    public ZeroDiffRule(DJep dJep, String string) {
        this.name = string;
        this.pfmc = dJep.getFunctionTable().getFunction(this.name);
        this.nf = dJep.getNodeFactory();
        this.zero = dJep.getNumberFactory().getZero();
    }

    public ZeroDiffRule(DJep dJep, String string, PostfixMathCommandI postfixMathCommandI) {
        this.name = string;
        this.pfmc = postfixMathCommandI;
        this.nf = dJep.getNodeFactory();
        this.zero = dJep.getNumberFactory().getZero();
    }

    public ZeroDiffRule(DJep dJep, Operator operator) {
        this(dJep, operator.getName(), operator.getPFMC());
        this.nf = dJep.getNodeFactory();
        this.zero = dJep.getNumberFactory().getZero();
    }

    @Override
    public void init(Jep jep) {
        this.nf = jep.getNodeFactory();
        this.zero = jep.getNumberFactory().getZero();
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return null;
    }

    @Override
    public String toString() {
        if (this.pfmc == null) {
            return this.name + " Passthrough but no math command!";
        }
        switch (this.pfmc.getNumberOfParameters()) {
            case 0: {
                return "diff(" + this.name + ",x) -> 0";
            }
            case 1: {
                return "diff(" + this.name + "a,x) -> 0";
            }
            case 2: {
                return "diff(a" + this.name + "b,x) -> 0";
            }
        }
        return "diff(a" + this.name + "b" + this.name + "...,x) -> 0";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Node differentiate(ASTFunNode aSTFunNode, String string, Node[] nodeArray, Node[] nodeArray2) throws ParseException {
        return this.nf.buildConstantNode(this.zero);
    }
}

