/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.fastmatrix;

import com.singularsys.extensions.fastmatrix.MScalerStore;
import com.singularsys.extensions.fastmatrix.MrpEval;
import com.singularsys.extensions.fastmatrix.MrpRes;
import com.singularsys.extensions.matrix.DimensionVisitor;
import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.Variable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

abstract class MObjStore
implements Serializable {
    private static final long serialVersionUID = 330L;
    protected static final String ls = System.getProperty("line.separator");
    MrpEval mrpe;
    int sp = 0;
    int stackMax = 0;
    protected int hp;
    int heapMax = 0;
    List<Variable> jepVarIndex = new ArrayList<Variable>();
    protected MScalerStore scalerStore;

    MObjStore(MrpEval mrpEval) {
        this.mrpe = mrpEval;
        this.scalerStore = this.mrpe.scalerStore;
    }

    abstract Dimensions getStoreDimensions();

    final void incStack() {
        ++this.sp;
        if (this.sp > this.stackMax) {
            this.stackMax = this.sp;
        }
    }

    void decStack() throws ParseException {
        --this.sp;
        if (this.sp < 0) {
            throw new ParseException("RPEval: stack error");
        }
    }

    protected void incHeap() {
        ++this.hp;
        if (this.hp > this.heapMax) {
            this.heapMax = this.hp;
        }
    }

    protected void rewind() {
        this.sp = 0;
        this.hp = 0;
    }

    abstract void alloc();

    final int addVar(Variable variable, Dimensions dimensions) throws ParseException {
        int n = this.jepVarIndex.indexOf(variable);
        if (n == -1) {
            n = this.expandVarArray(dimensions);
            this.jepVarIndex.add(n, variable);
            if (variable.hasValidValue() && variable.getValue() != null) {
                try {
                    this.copyFromJepVar(n, variable);
                }
                catch (EvaluationException evaluationException) {
                    throw new ParseException(evaluationException);
                }
            }
        } else if (!this.getVarValue(n).getDimensions().equals(dimensions)) {
            if (variable.hasValidValue() && variable.getValue() != null) {
                try {
                    this.copyFromJepVar(n, variable);
                }
                catch (EvaluationException evaluationException) {
                    throw new ParseException(evaluationException);
                }
            } else {
                this.modifyVarDim(n, dimensions);
            }
        }
        return n;
    }

    abstract void modifyVarDim(int var1, Dimensions var2);

    void removeVariable(Variable variable) {
        int n = this.jepVarIndex.indexOf(variable);
        this.jepVarIndex.set(n, null);
        this.removeVarAt(n);
    }

    abstract void removeVarAt(int var1);

    void updateToJepVariables() throws EvaluationException {
        int n = this.jepVarIndex.size();
        for (int i = 0; i < n; ++i) {
            Variable variable = this.jepVarIndex.get(i);
            if (variable == null) continue;
            Object object = variable.getValue();
            MrpRes mrpRes = this.getVarValue(i);
            if (mrpRes.equals(object)) continue;
            Object object2 = this.mrpe.convertResult(mrpRes);
            variable.setValue(object2);
        }
    }

    void updateFromJepVariables() throws EvaluationException {
        int n = this.jepVarIndex.size();
        for (int i = 0; i < n; ++i) {
            Variable variable = this.jepVarIndex.get(i);
            if (variable == null) continue;
            Object object = variable.getValue();
            MrpRes mrpRes = this.getVarValue(i);
            Dimensions dimensions = (Dimensions)variable.getHook(DimensionVisitor.DIM_KEY);
            if (!dimensions.equals(mrpRes.getDimensions())) {
                System.out.println("Jep variable (" + variable.toString() + ") dim " + dimensions + " different dimensions to MRp vraiable " + mrpRes.getDimensions());
                this.jepVarIndex.set(i, null);
                continue;
            }
            if (mrpRes.equals(object)) continue;
            this.copyFromJepVar(i, variable);
        }
    }

    abstract void copyFromJepVar(int var1, Variable var2) throws EvaluationException;

    abstract int expandVarArray(Dimensions var1);

    final Variable getJepVariable(int n) {
        return this.jepVarIndex.get(n);
    }

    abstract MrpRes getVarValue(int var1);

    abstract int getNVars();

    abstract void cleanUp();

    abstract void pushVariable(int var1);

    abstract void pushConstant(int var1);

    abstract void eq();

    abstract void ne();

    abstract void assign(int var1);

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Store dim " + this.getStoreDimensions() + " ");
        stringBuilder.append("Stack size " + this.stackMax);
        stringBuilder.append(" Heep size " + this.heapMax);
        int n = this.getNVars();
        if (n > 0) {
            stringBuilder.append(ls + "Variables");
        } else {
            stringBuilder.append("\t no variables");
        }
        stringBuilder.append(ls);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(i);
            stringBuilder.append('\t');
            Variable variable = this.getJepVariable(i);
            if (variable != null) {
                stringBuilder.append(variable.getName());
            } else {
                stringBuilder.append("null");
            }
            stringBuilder.append('\t');
            stringBuilder.append(this.getVarValue(i));
            stringBuilder.append(ls);
        }
        return stringBuilder.toString();
    }
}

