/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.fastmatrix;

import com.singularsys.extensions.fastmatrix.MrpRes;
import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.jep.EvaluationException;

final class MatObj
extends MrpRes {
    double[] data;
    int rows;
    int cols;
    int len;

    MatObj(int n, int n2) {
        this.data = new double[n * n2];
        this.rows = n;
        this.cols = n2;
        this.len = n * n2;
    }

    @Override
    public Dimensions getDimensions() {
        return Dimensions.valueOf(this.rows, this.cols);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < this.rows; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('[');
            for (int j = 0; j < this.cols; ++j) {
                if (j > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.data[i * this.cols + j]);
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    @Override
    public void copyToMat(MatrixI matrixI) throws EvaluationException {
        if (!matrixI.getDimensions().equalsDim(this.getDimensions())) {
            throw new EvaluationException("Wrong dimensions for result, expected " + this.getDimensions() + " found " + matrixI.getDimensions());
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                matrixI.setEle(i, j, new Double(this.data[i * this.cols + j]));
            }
        }
    }

    @Override
    public double[][] toArrayMat() {
        double[][] dArray = new double[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                dArray[i][j] = this.data[i * this.cols + j];
            }
        }
        return dArray;
    }

    void fromMat(MatrixI matrixI) {
        int n = matrixI.getNRows();
        int n2 = matrixI.getNCols();
        if (this.data == null || this.rows != n || this.cols != n2) {
            this.rows = n;
            this.cols = n2;
            this.len = this.rows * this.cols;
            this.data = new double[this.len];
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.data[i * this.cols + j] = (Double)matrixI.getEle(i, j);
            }
        }
    }

    public void setEle(int n, int n2, double d) {
        this.data[n * this.cols + n2] = d;
    }

    @Override
    public void copyToVec(VectorI vectorI) throws EvaluationException {
        throw new EvaluationException("Cannont convert matrix to a vector");
    }

    @Override
    public double[] toArrayVec() {
        return null;
    }

    @Override
    public Double[][] toDoubleMat() throws EvaluationException {
        return this.toArray(new Double[this.rows][this.cols]);
    }

    @Override
    public Double[] toDoubleVec() throws EvaluationException {
        throw new EvaluationException("Cannont convert matrix to a vector");
    }

    Double[][] toArray(Double[][] doubleArray) throws EvaluationException {
        if (doubleArray.length != this.rows || doubleArray[0].length != this.cols) {
            throw new EvaluationException("Wrong size for results expected " + this.rows + ", " + this.cols + " found " + doubleArray.length + ", " + doubleArray[0].length);
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                doubleArray[i][j] = this.data[i * this.cols + j];
            }
        }
        return doubleArray;
    }
}

