/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.fastmatrix;

import com.singularsys.extensions.fastmatrix.MrpEval;
import com.singularsys.extensions.fastreal.AbstractEval;
import com.singularsys.extensions.matrix.Dimensions;

public final class MrpCommandList {
    private static final int STACK_INC = 10;
    public MrpCommand[] commands = new MrpCommand[10];
    private short commandPos;
    private int finalType;
    private Dimensions resultDim;

    public final void addCommand(short s, short s2) {
        if (this.commandPos == this.commands.length) {
            MrpCommand[] mrpCommandArray = new MrpCommand[this.commands.length + 10];
            System.arraycopy(this.commands, 0, mrpCommandArray, 0, this.commands.length);
            this.commands = mrpCommandArray;
        }
        this.commands[this.commandPos] = new MrpCommand(s, s2);
        this.commandPos = (short)(this.commandPos + 1);
    }

    public final void addCommand(short s, short s2, short s3) {
        if (this.commandPos == this.commands.length) {
            MrpCommand[] mrpCommandArray = new MrpCommand[this.commands.length + 10];
            System.arraycopy(this.commands, 0, mrpCommandArray, 0, this.commands.length);
            this.commands = mrpCommandArray;
        }
        this.commands[this.commandPos] = new MrpCommand(s, s2, s3);
        this.commandPos = (short)(this.commandPos + 1);
    }

    public final void addCommand(short s, short s2, short s3, short s4) {
        if (this.commandPos == this.commands.length) {
            MrpCommand[] mrpCommandArray = new MrpCommand[this.commands.length + 10];
            System.arraycopy(this.commands, 0, mrpCommandArray, 0, this.commands.length);
            this.commands = mrpCommandArray;
        }
        this.commands[this.commandPos] = new MrpCommand(s, s2, s3, s4);
        this.commandPos = (short)(this.commandPos + 1);
    }

    public final void addCommand(short s, short s2, short s3, short s4, short s5) {
        if (this.commandPos == this.commands.length) {
            MrpCommand[] mrpCommandArray = new MrpCommand[this.commands.length + 10];
            System.arraycopy(this.commands, 0, mrpCommandArray, 0, this.commands.length);
            this.commands = mrpCommandArray;
        }
        this.commands[this.commandPos] = new MrpCommand(s, s2, s3, s4, s5);
        this.commandPos = (short)(this.commandPos + 1);
    }

    public int getNumCommands() {
        return this.commandPos;
    }

    public int getFinalType() {
        return this.finalType;
    }

    public void setResultDim(Dimensions dimensions, short s) {
        this.resultDim = dimensions;
        this.finalType = s;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.commandPos; ++i) {
            stringBuffer.append(this.commands[i].toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public Dimensions getDimsOfResult() {
        return this.resultDim;
    }

    public static final class MrpCommand {
        public short command;
        public short aux1;
        public short aux2;
        public short aux3;
        public short aux4;

        public MrpCommand(short s, short s2) {
            this.command = s;
            this.aux1 = s2;
            this.aux2 = (short)-1;
        }

        public MrpCommand(short s, short s2, short s3) {
            this.command = s;
            this.aux1 = s2;
            this.aux2 = s3;
        }

        public MrpCommand(short s, short s2, short s3, short s4) {
            this.command = s;
            this.aux1 = s2;
            this.aux2 = s3;
            this.aux3 = s4;
        }

        public MrpCommand(short s, short s2, short s3, short s4, short s5) {
            this.command = s;
            this.aux1 = s2;
            this.aux2 = s3;
            this.aux3 = s4;
            this.aux4 = s5;
        }

        private static final String dimTypeToString(int n) {
            switch (n) {
                case 1: {
                    return Dimensions.ONE.toString();
                }
                case 5: {
                    return "VN";
                }
                case 15: {
                    return "MNN";
                }
            }
            return "null";
        }

        public String toString() {
            switch (this.command) {
                case 0: {
                    return "Constant\tnum " + this.aux1;
                }
                case 1: {
                    return "Variable\ttype " + MrpCommand.dimTypeToString(this.aux1) + "\tnum " + this.aux2;
                }
                case 2: {
                    return "ADD\ttype " + MrpCommand.dimTypeToString(this.aux1) + " hp " + this.aux2;
                }
                case 3: {
                    return "SUB\ttype " + MrpCommand.dimTypeToString(this.aux1) + " hp " + this.aux2;
                }
                case 4: {
                    return "MUL\ttype " + MrpCommand.dimTypeToString(this.aux1) + " by " + MrpCommand.dimTypeToString(this.aux2) + " hp " + this.aux3;
                }
                case 5: {
                    return "DIV\ttype " + MrpCommand.dimTypeToString(this.aux1) + " hp " + this.aux2;
                }
                case 6: {
                    return "MOD\ttype " + MrpCommand.dimTypeToString(this.aux1);
                }
                case 7: {
                    return "POW\ttype " + MrpCommand.dimTypeToString(this.aux1);
                }
                case 8: {
                    return "AND\ttype " + MrpCommand.dimTypeToString(this.aux1);
                }
                case 9: {
                    return "OR\ttype " + MrpCommand.dimTypeToString(this.aux1);
                }
                case 10: {
                    return "NOT\ttype " + MrpCommand.dimTypeToString(this.aux1);
                }
                case 11: {
                    return "LT\ttype " + MrpCommand.dimTypeToString(this.aux1);
                }
                case 13: {
                    return "GT\ttype " + MrpCommand.dimTypeToString(this.aux1);
                }
                case 12: {
                    return "LE\ttype " + MrpCommand.dimTypeToString(this.aux1);
                }
                case 14: {
                    return "GE\ttype " + MrpCommand.dimTypeToString(this.aux1);
                }
                case 15: {
                    return "NE\ttype " + MrpCommand.dimTypeToString(this.aux1);
                }
                case 16: {
                    return "EQ\ttype " + MrpCommand.dimTypeToString(this.aux1);
                }
                case 17: {
                    return "List type " + MrpCommand.dimTypeToString(this.aux1) + " hp " + this.aux2;
                }
                case 18: {
                    return "Dot type " + MrpCommand.dimTypeToString(this.aux1) + " hp " + this.aux2;
                }
                case 19: {
                    return "Cross type " + MrpCommand.dimTypeToString(this.aux1);
                }
                case 20: {
                    return "Assign type " + MrpCommand.dimTypeToString(this.aux1) + " no " + this.aux2;
                }
                case 21: {
                    return "UMinus\ttype " + MrpCommand.dimTypeToString(this.aux1) + " hp " + this.aux2;
                }
                case 22: {
                    return "Power x^" + this.aux1;
                }
                case 23: {
                    return "RECIP";
                }
                case 24: {
                    return "VList " + this.aux1 + " hp " + this.aux2;
                }
                case 25: {
                    return "MList " + this.aux1 + ", " + this.aux2 + " hp " + this.aux3;
                }
                case 27: {
                    return "ListList " + this.aux1;
                }
                case 28: {
                    return "MListList " + this.aux1 + ", " + this.aux2;
                }
            }
            return "Function " + AbstractEval.staticGetFunction(this.command - 50) + " args " + this.aux1 + " " + this.aux2 + " " + this.aux3 + " " + this.aux4;
        }

        public String toString(MrpEval mrpEval) {
            if (this.command < 50) {
                return this.toString();
            }
            switch (this.command) {
                case 50: {
                    return "Function 0 args\t" + mrpEval.getFunction(this.aux1) + " " + this.aux2 + " " + this.aux3 + " " + this.aux4;
                }
                case 51: {
                    return "Function 1 arg\t" + mrpEval.getFunction(this.aux1) + " " + this.aux2 + " " + this.aux3 + " " + this.aux4;
                }
                case 52: {
                    return "Function 2 args\t" + mrpEval.getFunction(this.aux1) + " " + this.aux2 + " " + this.aux3 + " " + this.aux4;
                }
                case 53: {
                    return "Function 3 args\t" + mrpEval.getFunction(this.aux1) + " " + this.aux2 + " " + this.aux3 + " " + this.aux4;
                }
                case 54: {
                    return "Function 4 args\t" + mrpEval.getFunction(this.aux1) + " " + this.aux2 + " " + this.aux3 + " " + this.aux4;
                }
            }
            return "Function " + mrpEval.getFunction(this.command - 50) + " args " + this.aux1 + " " + this.aux2 + " " + this.aux3 + " " + this.aux4;
        }
    }
}

