/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.fastmatrix;

import com.singularsys.extensions.fastmatrix.MObjStore;
import com.singularsys.extensions.fastmatrix.MrpEval;
import com.singularsys.extensions.fastmatrix.VecObj;
import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.Variable;
import java.util.ArrayList;
import java.util.List;

final class VecStore
extends MObjStore {
    private static final long serialVersionUID = 350L;
    final int neles;
    VecObj[] stack;
    List<VecObj> heap = new ArrayList<VecObj>();
    VecObj[] vars = new VecObj[0];
    VecObj[] cnst = new VecObj[0];

    VecStore(MrpEval mrpEval) {
        super(mrpEval);
        this.neles = -1;
    }

    @Override
    protected final void alloc() {
        this.stack = new VecObj[this.stackMax];
    }

    public void add(short s) {
        VecObj vecObj = this.stack[--this.sp];
        VecObj vecObj2 = this.stack[--this.sp];
        VecObj vecObj3 = this.heap.get(s);
        for (int i = 0; i < vecObj2.data.length; ++i) {
            vecObj3.data[i] = vecObj2.data[i] + vecObj.data[i];
        }
        this.stack[this.sp++] = vecObj3;
    }

    public final void sub(short s) {
        VecObj vecObj = this.stack[--this.sp];
        VecObj vecObj2 = this.stack[--this.sp];
        VecObj vecObj3 = this.heap.get(s);
        for (int i = 0; i < vecObj2.data.length; ++i) {
            vecObj3.data[i] = vecObj2.data[i] - vecObj.data[i];
        }
        this.stack[this.sp++] = vecObj3;
    }

    final void neg(short s) {
        VecObj vecObj = this.stack[--this.sp];
        VecObj vecObj2 = this.heap.get(s);
        for (int i = 0; i < vecObj.data.length; ++i) {
            vecObj2.data[i] = -vecObj.data[i];
        }
        this.stack[this.sp++] = vecObj2;
    }

    final void mulS(short s) {
        VecObj vecObj = this.stack[--this.sp];
        double d = this.mrpe.scalerStore.popDouble();
        VecObj vecObj2 = this.heap.get(s);
        for (int i = 0; i < vecObj.data.length; ++i) {
            vecObj2.data[i] = d * vecObj.data[i];
        }
        this.stack[this.sp++] = vecObj2;
    }

    final void divS(short s) {
        VecObj vecObj = this.stack[--this.sp];
        double d = this.mrpe.scalerStore.popDouble();
        VecObj vecObj2 = this.heap.get(s);
        for (int i = 0; i < vecObj.data.length; ++i) {
            vecObj2.data[i] = vecObj.data[i] / d;
        }
        this.stack[this.sp++] = vecObj2;
    }

    final void makeList(int n, short s) {
        VecObj vecObj = this.heap.get(s);
        for (int i = n - 1; i >= 0; --i) {
            vecObj.data[i] = this.mrpe.scalerStore.popDouble();
        }
        this.stack[this.sp++] = vecObj;
    }

    @Override
    public final void assign(int n) {
        VecObj vecObj = this.stack[this.sp - 1];
        VecObj vecObj2 = this.vars[n];
        for (int i = 0; i < vecObj.data.length; ++i) {
            vecObj2.data[i] = vecObj.data[i];
        }
    }

    @Override
    public final void eq() {
        VecObj vecObj = this.stack[--this.sp];
        VecObj vecObj2 = this.stack[--this.sp];
        for (int i = 0; i < vecObj.data.length; ++i) {
            if (vecObj2.data[i] == vecObj.data[i]) continue;
            this.mrpe.scalerStore.pushDouble(0.0);
            return;
        }
        this.mrpe.scalerStore.pushDouble(1.0);
    }

    @Override
    public final void ne() {
        VecObj vecObj = this.stack[--this.sp];
        VecObj vecObj2 = this.stack[--this.sp];
        for (int i = 0; i < vecObj.data.length; ++i) {
            if (vecObj2.data[i] == vecObj.data[i]) continue;
            this.mrpe.scalerStore.pushDouble(1.0);
            return;
        }
        this.mrpe.scalerStore.pushDouble(0.0);
    }

    @Override
    VecObj getVarValue(int n) {
        return this.vars[n];
    }

    @Override
    int getNVars() {
        return this.vars.length;
    }

    @Override
    void pushVariable(int n) {
        this.stack[this.sp++] = this.vars[n];
    }

    void setVarValue(int n, VectorI vectorI) {
        this.vars[n].fromVec(vectorI);
    }

    final void setVarValue(int n, double[] dArray) {
        this.vars[n].fromArray(dArray);
    }

    @Override
    void removeVarAt(int n) {
        this.vars[n] = null;
    }

    @Override
    void modifyVarDim(int n, Dimensions dimensions) {
        this.vars[n] = new VecObj(dimensions.getFirstDim());
    }

    short addConstant(VectorI vectorI) {
        VecObj vecObj = new VecObj(vectorI.getNEles());
        vecObj.fromVec(vectorI);
        int n = this.cnst.length;
        VecObj[] vecObjArray = new VecObj[n + 1];
        System.arraycopy(this.cnst, 0, vecObjArray, 0, n);
        vecObjArray[n] = vecObj;
        this.cnst = vecObjArray;
        return (short)n;
    }

    @Override
    final void copyFromJepVar(int n, Variable variable) throws EvaluationException {
        Object object = variable.getValue();
        VecObj vecObj = this.vars[n];
        if (!(object instanceof VectorI) || ((VectorI)object).getNEles() != vecObj.len) {
            throw new EvaluationException("Variable (" + variable + ") of wrong size expected vector of length " + this.neles);
        }
        this.setVarValue(n, (VectorI)object);
    }

    @Override
    final int expandVarArray(Dimensions dimensions) {
        VecObj[] vecObjArray = new VecObj[this.vars.length + 1];
        System.arraycopy(this.vars, 0, vecObjArray, 0, this.vars.length);
        vecObjArray[this.vars.length] = new VecObj(dimensions.getFirstDim());
        this.vars = vecObjArray;
        return this.vars.length - 1;
    }

    @Override
    void cleanUp() {
        this.jepVarIndex.clear();
        this.vars = new VecObj[0];
        this.cnst = new VecObj[0];
        this.stackMax = 0;
        this.heapMax = 0;
        this.heap.clear();
        this.stack = null;
    }

    @Override
    void pushConstant(int n) {
        this.stack[this.sp++] = this.cnst[n];
    }

    VecObj popVecObj() {
        return this.stack[--this.sp];
    }

    final VecObj nextVecObj() {
        throw new UnsupportedOperationException("nextVecObj is not defined for VnStore and should not b called");
    }

    final void pushVecObj(VecObj vecObj) {
        this.stack[this.sp++] = vecObj;
    }

    @Override
    protected void incHeap() {
        throw new IllegalStateException("incHeap should be called with a specied length");
    }

    public short incHeap(int n) {
        ++this.heapMax;
        VecObj vecObj = new VecObj(n);
        this.heap.add(vecObj);
        return (short)(this.heap.size() - 1);
    }

    VecObj getHeapObj(short s) {
        return this.heap.get(s);
    }

    @Override
    Dimensions getStoreDimensions() {
        return Dimensions.valueOf(10);
    }

    @Override
    public void decStack() throws ParseException {
        --this.sp;
        if (this.sp < 0) {
            throw new ParseException("RPEval: stack error");
        }
    }
}

