/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.fastreal;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepException;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.Variable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;

abstract class ObjStore
implements Observer,
Serializable {
    private static final long serialVersionUID = 330L;
    protected static final String ls = System.getProperty("line.separator");
    protected int sp = 0;
    protected int stackMax = 0;
    protected final Map<Variable, Integer> varRefs = new HashMap<Variable, Integer>();
    protected Variable[] jepVarIndex = new Variable[0];

    ObjStore() {
    }

    public final void incStack() {
        ++this.sp;
        if (this.sp > this.stackMax) {
            this.stackMax = this.sp;
        }
    }

    public void decStack() throws ParseException {
        --this.sp;
        if (this.sp < 0) {
            throw new ParseException("RPEval: stack error");
        }
    }

    public void reset() {
        this.sp = 0;
    }

    protected abstract void alloc();

    protected abstract short addConstant(Object var1) throws ParseException;

    protected abstract Object getConstant(int var1);

    protected abstract int getNConst();

    public final int addVar(Variable variable) throws JepException {
        Integer n = this.varRefs.get(variable);
        if (n == null) {
            int n2 = this.varRefs.size();
            this.expandVarArray(n2 + 1);
            this.varRefs.put(variable, n2);
            this.copyFromVar(n2, variable);
            variable.addObserver(this);
            Variable[] variableArray = new Variable[n2 + 1];
            System.arraycopy(this.jepVarIndex, 0, variableArray, 0, n2);
            variableArray[n2] = variable;
            this.jepVarIndex = variableArray;
            return n2;
        }
        this.jepVarIndex[n.intValue()] = variable;
        return n;
    }

    public void updateJepVariables() {
        int n = this.jepVarIndex.length;
        for (int i = 0; i < n; ++i) {
            Variable variable = this.jepVarIndex[i];
            Object object = variable.getValue();
            Object object2 = this.getVarValue(i);
            if (object2.equals(object)) continue;
            variable.setValue(object2, this);
        }
    }

    @Override
    public final void update(Observable observable, Object object) {
        if (object == this) {
            return;
        }
        if (observable instanceof Variable) {
            Variable variable = (Variable)observable;
            int n = this.varRefs.get(variable);
            if (n < 0) {
                return;
            }
            try {
                this.copyFromVar(n, variable);
            }
            catch (JepException jepException) {
                jepException.printStackTrace();
            }
        }
    }

    protected abstract void copyFromVar(int var1, Variable var2) throws JepException;

    protected abstract void expandVarArray(int var1);

    public final Variable getJepVariable(int n) {
        return this.jepVarIndex[n];
    }

    protected abstract Object getVarValue(int var1);

    protected abstract int getNVars();

    public final void cleanUp() {
        for (Variable variable : this.varRefs.keySet()) {
            variable.deleteObserver(this);
        }
        this.varRefs.clear();
        this.jepVarIndex = new Variable[0];
    }

    protected abstract ObjStore duplicate() throws CloneNotSupportedException;

    protected abstract void pushVariable(int var1);

    protected abstract void pushConstant(int var1);

    protected abstract void assign(int var1);

    protected abstract void add();

    protected abstract void sub();

    protected abstract void neg();

    protected abstract void mul();

    protected abstract void div();

    protected abstract void mod();

    protected abstract void recroprical();

    protected abstract void pow();

    protected abstract void powN(short var1);

    protected abstract void and();

    protected abstract void or();

    protected abstract void not();

    protected abstract void eq();

    protected abstract void ne();

    protected abstract void lt();

    protected abstract void gt();

    protected abstract void le();

    protected abstract void ge();

    protected abstract Object popObject();

    protected abstract void popN(int var1, Stack<Object> var2);

    protected abstract void pushObject(Object var1) throws EvaluationException;

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Stack size " + this.stackMax);
        stringBuilder.append("Variables");
        stringBuilder.append(ls);
        int n2 = this.getNVars();
        for (n = 0; n < n2; ++n) {
            stringBuilder.append(n);
            stringBuilder.append('\t');
            stringBuilder.append(this.getJepVariable(n).getName());
            stringBuilder.append('\t');
            stringBuilder.append(this.getVarValue(n));
            stringBuilder.append(ls);
        }
        stringBuilder.append("Constants");
        stringBuilder.append(ls);
        n2 = this.getNConst();
        for (n = 0; n < n2; ++n) {
            stringBuilder.append(n);
            stringBuilder.append('\t');
            stringBuilder.append(this.getConstant((short)n));
            stringBuilder.append(ls);
        }
        return stringBuilder.toString();
    }
}

