/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.functions;

import com.singularsys.extensions.field.FieldI;
import com.singularsys.extensions.field.functions.FieldAbs;
import com.singularsys.extensions.field.functions.FieldBinomial;
import com.singularsys.extensions.field.functions.FieldMod;
import com.singularsys.extensions.field.functions.FieldPower;
import com.singularsys.extensions.field.functions.FieldSignum;
import com.singularsys.extensions.field.functions.RationalRound;
import com.singularsys.extensions.field.implementations.Rational;
import com.singularsys.extensions.statistical.ElementMinMax;
import com.singularsys.extensions.statistical.ElementSum;
import com.singularsys.extensions.statistical.Mean;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.FunctionTable;
import com.singularsys.jep.functions.UnaryFunction;
import java.math.RoundingMode;

public class RationalFunctionTable
extends FunctionTable {
    private static final long serialVersionUID = 350L;

    public RationalFunctionTable(FieldI fieldI) {
        this.addFunction("abs", new FieldAbs(fieldI));
        this.addFunction("avg", new Mean(fieldI));
        this.addFunction("binom", new FieldBinomial(fieldI));
        this.addFunction("mod", new FieldMod(fieldI));
        this.addFunction("pow", new FieldPower(fieldI));
        this.addFunction("signum", new FieldSignum(fieldI));
        this.addFunction("sum", new ElementSum(fieldI));
        this.addFunction("vsum", new ElementSum(fieldI));
        this.addFunction("min", new ElementMinMax(ElementMinMax.Type.MIN, fieldI));
        this.addFunction("max", new ElementMinMax(ElementMinMax.Type.MAX, fieldI));
        this.addFunction("ceil", new RationalRound(RoundingMode.CEILING));
        this.addFunction("floor", new RationalRound(RoundingMode.FLOOR));
        this.addFunction("round", new RationalRound(RoundingMode.HALF_UP));
        this.addFunction("rint", new RationalRound(RoundingMode.HALF_EVEN));
        this.addFunction("numerator", new UnaryFunction(){
            private static final long serialVersionUID = 350L;

            @Override
            public Object eval(Object object) throws EvaluationException {
                Rational rational = (Rational)object;
                return new Rational(rational.getNumerator());
            }
        });
        this.addFunction("denominator", new UnaryFunction(){
            private static final long serialVersionUID = 350L;

            @Override
            public Object eval(Object object) throws EvaluationException {
                Rational rational = (Rational)object;
                return new Rational(rational.getDenominator());
            }
        });
    }
}

