/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.implementations;

import com.singularsys.extensions.field.FieldI;
import com.singularsys.extensions.field.implementations.FieldDecorator;
import com.singularsys.extensions.field.implementations.Rational;
import com.singularsys.jep.EvaluationException;
import java.math.BigInteger;

public class BigIntegerToRationalDecorator
extends FieldDecorator {
    private static final long serialVersionUID = 350L;
    boolean simplifyResults = false;

    public BigIntegerToRationalDecorator(FieldI fieldI) {
        super(fieldI);
    }

    public BigIntegerToRationalDecorator(FieldI fieldI, boolean bl) {
        super(fieldI);
        this.simplifyResults = bl;
    }

    @Override
    public Object convertInput(Object object) throws EvaluationException {
        if (object instanceof Rational) {
            return object;
        }
        if (object instanceof Integer) {
            return new Rational((Integer)object);
        }
        if (object instanceof Long) {
            return new Rational((Long)object);
        }
        if (object instanceof Short) {
            return new Rational(((Short)object).shortValue());
        }
        if (object instanceof BigInteger) {
            return new Rational((BigInteger)object);
        }
        return object;
    }

    @Override
    public Object convertOutput(Object object) throws EvaluationException {
        Rational rational;
        if (this.simplifyResults && object instanceof Rational && (rational = (Rational)object).getDenominator().equals(BigInteger.ONE)) {
            return rational.getNumerator();
        }
        return object;
    }
}

