/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.implementations;

import com.singularsys.extensions.field.implementations.GenericField;
import com.singularsys.jep.EvaluationException;
import java.math.BigInteger;

public class BigModulusField
extends GenericField<BigInteger> {
    private static final long serialVersionUID = 1L;
    BigInteger modulus;

    public BigModulusField(BigInteger bigInteger) {
        this.modulus = bigInteger;
    }

    @Override
    public BigInteger cast(Object object) {
        if (object instanceof BigInteger) {
            return ((BigInteger)object).mod(this.modulus);
        }
        return null;
    }

    @Override
    public BigInteger addG(BigInteger bigInteger, BigInteger bigInteger2) throws EvaluationException {
        BigInteger bigInteger3 = bigInteger.add(bigInteger2);
        BigInteger bigInteger4 = bigInteger3.mod(this.modulus);
        return bigInteger4;
    }

    @Override
    public BigInteger subG(BigInteger bigInteger, BigInteger bigInteger2) throws EvaluationException {
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        BigInteger bigInteger4 = bigInteger3.mod(this.modulus);
        return bigInteger4;
    }

    @Override
    public BigInteger negG(BigInteger bigInteger) throws EvaluationException {
        BigInteger bigInteger2 = this.modulus.subtract(bigInteger);
        return bigInteger2;
    }

    @Override
    public BigInteger mulG(BigInteger bigInteger, BigInteger bigInteger2) throws EvaluationException {
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        BigInteger bigInteger4 = bigInteger3.mod(this.modulus);
        return bigInteger4;
    }

    @Override
    public BigInteger divG(BigInteger bigInteger, BigInteger bigInteger2) throws EvaluationException {
        return bigInteger.multiply(bigInteger2.modInverse(this.modulus)).mod(this.modulus);
    }

    @Override
    public BigInteger modG(BigInteger bigInteger, BigInteger bigInteger2) throws EvaluationException {
        return bigInteger.mod(bigInteger2).mod(this.modulus);
    }

    @Override
    public BigInteger powG(BigInteger bigInteger, BigInteger bigInteger2) throws EvaluationException {
        return bigInteger.modPow(bigInteger2, this.modulus);
    }

    @Override
    public Integer cmpG(BigInteger bigInteger, BigInteger bigInteger2) throws EvaluationException {
        return null;
    }

    @Override
    public Boolean eq(Object object, Object object2) throws EvaluationException {
        BigInteger bigInteger = this.cast(object);
        if (bigInteger == null) {
            return null;
        }
        BigInteger bigInteger2 = this.cast(object2);
        if (bigInteger2 == null) {
            return null;
        }
        return bigInteger.equals(bigInteger2);
    }

    @Override
    public Boolean ne(Object object, Object object2) throws EvaluationException {
        BigInteger bigInteger = this.cast(object);
        if (bigInteger == null) {
            return null;
        }
        BigInteger bigInteger2 = this.cast(object2);
        if (bigInteger2 == null) {
            return null;
        }
        return !bigInteger.equals(bigInteger2);
    }

    @Override
    public Boolean gt(Object object, Object object2) throws EvaluationException {
        return null;
    }

    @Override
    public Boolean ge(Object object, Object object2) throws EvaluationException {
        return null;
    }

    @Override
    public Boolean lt(Object object, Object object2) throws EvaluationException {
        return null;
    }

    @Override
    public Boolean le(Object object, Object object2) throws EvaluationException {
        return null;
    }

    @Override
    public BigInteger getOne() {
        return BigInteger.ONE;
    }

    @Override
    public BigInteger getZero() {
        return BigInteger.ZERO;
    }

    @Override
    public Integer convertToIntE(BigInteger bigInteger) throws EvaluationException {
        try {
            int n = bigInteger.intValueExact();
            return n;
        }
        catch (ArithmeticException arithmeticException) {
            return null;
        }
    }

    @Override
    public BigInteger convertFromInt(Integer n) throws EvaluationException {
        return BigInteger.valueOf(n.intValue());
    }
}

