/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.implementations;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.standard.Complex;

public class LongDoubleNumberFactory
implements NumberFactory {
    private static final long serialVersionUID = 330L;
    public static final Long MINUS_ONE = -1L;
    public static final Long ONE = 1L;
    public static final Long TWO = 2L;
    public static final Long ZERO = 0L;

    @Override
    public Object createNumber(String string) throws ParseException {
        double d = Double.parseDouble(string);
        return this.createNumber(d);
    }

    @Override
    public Object createNumber(double d) throws ParseException {
        long l = (long)d;
        if ((double)l == d) {
            return l;
        }
        return d;
    }

    @Override
    public Object createNumber(int n) throws ParseException {
        return (long)n;
    }

    @Override
    public Object createNumber(short s) throws ParseException {
        return (long)s;
    }

    @Override
    public Object createNumber(long l) throws ParseException {
        return l;
    }

    @Override
    public Object createNumber(float f) throws ParseException {
        return this.createNumber((double)f);
    }

    @Override
    public Object createNumber(boolean bl) throws ParseException {
        return bl;
    }

    @Override
    public Object createNumber(Number number) throws ParseException {
        return this.createNumber(number.doubleValue());
    }

    @Override
    public Object createNumber(Complex complex) throws ParseException {
        return complex;
    }

    @Override
    public Object getMinusOne() {
        return MINUS_ONE;
    }

    @Override
    public Object getOne() {
        return ONE;
    }

    @Override
    public Object getTwo() {
        return TWO;
    }

    @Override
    public Object getZero() {
        return ZERO;
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return null;
    }

    @Override
    public void init(Jep jep) {
    }
}

