/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.implementations;

import com.singularsys.extensions.field.implementations.GenericField;
import com.singularsys.jep.EvaluationException;

public class ModulusField
extends GenericField<Integer> {
    private static final long serialVersionUID = 1L;
    int modulus;

    public ModulusField(int n) {
        if (n >= 46341 || n <= 0) {
            throw new IllegalArgumentException("Modulus must be between 1 and 46341.");
        }
        this.modulus = n;
    }

    @Override
    public Integer cast(Object object) {
        if (object instanceof Number) {
            int n = ((Number)object).intValue();
            if ((n %= this.modulus) < 0) {
                n += this.modulus;
            }
            return n;
        }
        return null;
    }

    @Override
    public Integer addG(Integer n, Integer n2) throws EvaluationException {
        int n3 = n + n2;
        int n4 = n3 % this.modulus;
        return n4;
    }

    @Override
    public Integer subG(Integer n, Integer n2) throws EvaluationException {
        int n3 = n - n2;
        int n4 = n3 % this.modulus;
        if (n4 < 0) {
            n4 += this.modulus;
        }
        return n4;
    }

    @Override
    public Integer negG(Integer n) throws EvaluationException {
        int n2 = this.modulus - n;
        return n2;
    }

    @Override
    public Integer mulG(Integer n, Integer n2) throws EvaluationException {
        int n3 = n * n2;
        int n4 = n3 % this.modulus;
        return n4;
    }

    @Override
    public Integer divG(Integer n, Integer n2) throws EvaluationException {
        return null;
    }

    @Override
    public Integer modG(Integer n, Integer n2) throws EvaluationException {
        int n3 = n % n2;
        int n4 = n3 % this.modulus;
        if (n4 < 0) {
            n4 += this.modulus;
        }
        return n4;
    }

    @Override
    public Integer powG(Integer n, Integer n2) throws EvaluationException {
        int n3 = 1;
        int n4 = n;
        for (int i = n2.intValue(); i > 0; i >>= 1) {
            if (i % 2 == 1) {
                n3 = n3 * n4 % this.modulus;
            }
            n4 = n4 * n4 % this.modulus;
        }
        return n3;
    }

    @Override
    public Integer cmpG(Integer n, Integer n2) throws EvaluationException {
        return null;
    }

    @Override
    public Boolean eq(Object object, Object object2) throws EvaluationException {
        Integer n = this.cast(object);
        if (n == null) {
            return null;
        }
        Integer n2 = this.cast(object2);
        if (n2 == null) {
            return null;
        }
        return n == n2;
    }

    @Override
    public Boolean ne(Object object, Object object2) throws EvaluationException {
        Integer n = this.cast(object);
        if (n == null) {
            return null;
        }
        Integer n2 = this.cast(object2);
        if (n2 == null) {
            return null;
        }
        return n == n2;
    }

    @Override
    public Boolean gt(Object object, Object object2) throws EvaluationException {
        return null;
    }

    @Override
    public Boolean ge(Object object, Object object2) throws EvaluationException {
        return null;
    }

    @Override
    public Boolean lt(Object object, Object object2) throws EvaluationException {
        return null;
    }

    @Override
    public Boolean le(Object object, Object object2) throws EvaluationException {
        return null;
    }

    @Override
    public Integer getOne() {
        return 1;
    }

    @Override
    public Integer getZero() {
        return 0;
    }

    @Override
    public Integer convertToIntE(Integer n) throws EvaluationException {
        return n;
    }

    @Override
    public Integer convertFromInt(Integer n) throws EvaluationException {
        return n;
    }
}

