/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.implementations;

import com.singularsys.extensions.field.implementations.Rational;
import com.singularsys.extensions.field.implementations.SimpleNumberFactory;
import com.singularsys.jep.ParseException;
import java.math.BigInteger;

public class RationalNumberFactory
extends SimpleNumberFactory {
    private static final long serialVersionUID = 330L;

    public RationalNumberFactory() {
        super(Rational.MINUSONE, Rational.ZERO, Rational.ONE, Rational.TWO);
    }

    @Override
    public Rational createNumber(String string) throws ParseException {
        BigInteger bigInteger;
        try {
            bigInteger = new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException);
        }
        return new Rational(bigInteger);
    }

    @Override
    public Rational createNumber(double d) throws ParseException {
        long l = Double.valueOf(d).longValue();
        if ((double)l == d) {
            this.createNumber(l);
        }
        throw new ParseException("Cannot convert " + d + " to a Rational number");
    }

    @Override
    public Rational createNumber(int n) throws ParseException {
        return Rational.valueOf(n);
    }

    @Override
    public Rational createNumber(short s) throws ParseException {
        return Rational.valueOf(s);
    }

    @Override
    public Rational createNumber(long l) throws ParseException {
        return Rational.valueOf(l);
    }

    @Override
    public Rational createNumber(float f) throws ParseException {
        int n = Float.valueOf(f).intValue();
        if ((float)n == f) {
            return this.createNumber(n);
        }
        throw new ParseException("Cannot convert " + f + " to a Rational number");
    }

    @Override
    public Rational createNumber(Number number) throws ParseException {
        double d;
        long l = number.longValue();
        if ((double)l == (d = number.doubleValue())) {
            return Rational.valueOf(l);
        }
        throw new ParseException("Value " + number + " cannot be converted to a rational number");
    }
}

