/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.mathml;

import com.singularsys.extensions.mathml.builder.FunctionBuilder;
import com.singularsys.extensions.mathml.builder.LgBuilder;
import com.singularsys.extensions.mathml.builder.ListBuilder;
import com.singularsys.extensions.mathml.builder.MathMLDocumentBuilder;
import com.singularsys.extensions.mathml.builder.MathMLFragmentBuilder;
import com.singularsys.extensions.mathml.builder.NumberBuilder;
import com.singularsys.extensions.mathml.builder.OperatorBuilder;
import com.singularsys.extensions.mathml.builder.VariableBuilder;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepException;
import com.singularsys.jep.Operator;
import com.singularsys.jep.OperatorTableI;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class MathMLContentBuilder
implements MathMLDocumentBuilder {
    String namespacePrefix = null;
    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    DocumentBuilder db = this.dbf.newDocumentBuilder();
    NumberBuilder numberBuilder = new NumberBuilder();
    VariableBuilder varibleBuilder = new VariableBuilder();
    FunctionBuilder functionBuilder = new FunctionBuilder();
    OperatorBuilder operatorBuilder = new OperatorBuilder();

    public MathMLContentBuilder(Jep jep) throws ParserConfigurationException {
        this.varibleBuilder.putConstant("pi", "pi");
        this.varibleBuilder.putConstant("e", "ExponentialE");
        this.varibleBuilder.putConstant("i", "ImaginaryI");
        this.varibleBuilder.putConstant("true", "true");
        this.varibleBuilder.putConstant("false", "false");
        this.varibleBuilder.putEntity("pi", "\u03c0");
        this.varibleBuilder.putConstant("e", "ExponentialE");
        this.varibleBuilder.putConstant("i", "ImaginaryI");
        this.varibleBuilder.putConstant("true", "true");
        this.varibleBuilder.putConstant("false", "false");
        OperatorTableI operatorTableI = jep.getOperatorTable();
        this.operatorBuilder.put(operatorTableI.getAdd(), "plus");
        this.operatorBuilder.put(operatorTableI.getSubtract(), "minus");
        this.operatorBuilder.put(operatorTableI.getUMinus(), "minus");
        this.operatorBuilder.put(operatorTableI.getMultiply(), "times");
        this.operatorBuilder.put(operatorTableI.getDivide(), "divide");
        this.operatorBuilder.put(operatorTableI.getMod(), "rem");
        this.operatorBuilder.put(operatorTableI.getPower(), "power");
        this.operatorBuilder.put(operatorTableI.getEQ(), "eq");
        this.operatorBuilder.put(operatorTableI.getNE(), "neq");
        this.operatorBuilder.put(operatorTableI.getLE(), "leq");
        this.operatorBuilder.put(operatorTableI.getLT(), "lt");
        this.operatorBuilder.put(operatorTableI.getGE(), "geq");
        this.operatorBuilder.put(operatorTableI.getGT(), "gt");
        this.operatorBuilder.put(operatorTableI.getAnd(), "and");
        this.operatorBuilder.put(operatorTableI.getOr(), "or");
        this.operatorBuilder.put(operatorTableI.getNot(), "not");
        this.operatorBuilder.put(operatorTableI.getDot(), "scalarproduct");
        this.operatorBuilder.put(operatorTableI.getCross(), "vectorproduct");
        this.operatorBuilder.put(operatorTableI.getAssign(), "equivalent");
        this.operatorBuilder.put(operatorTableI.getEle(), "selector");
        this.operatorBuilder.put(operatorTableI.getList(), new ListBuilder(jep));
        this.putFunction("sin", "sin");
        this.putFunction("cos", "cos");
        this.putFunction("tan", "tan");
        this.putFunction("sec", "sec");
        this.putFunction("csc", "csc");
        this.putFunction("cot", "cot");
        this.putFunction("sinh", "sinh");
        this.putFunction("cosh", "cosh");
        this.putFunction("tanh", "tanh");
        this.putFunction("sech", "sech");
        this.putFunction("csch", "csch");
        this.putFunction("coth", "coth");
        this.putFunction("arcsin", "arcsin");
        this.putFunction("arccos", "arccos");
        this.putFunction("arctan", "arctan");
        this.putFunction("arccosh", "arccosh");
        this.putFunction("arccot", "arccot");
        this.putFunction("arccoth", "arccoth");
        this.putFunction("arccsc", "arccsc");
        this.putFunction("arccsch", "arccsch");
        this.putFunction("arcsec", "arcsec");
        this.putFunction("arcsech", "arcsech");
        this.putFunction("arcsinh", "arcsinh");
        this.putFunction("arctanh", "arctanh");
        this.putFunction("exp", "exp");
        this.putFunction("ln", "ln");
        this.putFunction("log", "log");
        this.putFunction("lg", new LgBuilder());
        this.putFunction("sqrt", "root");
        this.putFunction("atan", "arctan");
        this.putFunction("asin", "arcsin");
        this.putFunction("acos", "arccos");
        this.putFunction("atanh", "arctanh");
        this.putFunction("asinh", "arcsinh");
        this.putFunction("acosh", "arccosh");
        this.putFunction("floor", "floor");
        this.putFunction("ceil", "ceiling");
        this.putFunction("re", "real");
        this.putFunction("im", "imaginary");
        this.putFunction("conj", "conjugate");
        this.putFunction("arg", "arg");
        this.putFunction("cmod", "abs");
        this.putFunction("pow", "power");
        this.putFunction("abs", "abs");
        this.putFunction("min", "min");
        this.putFunction("max", "max");
        this.putFunction("mod", "rem");
    }

    public Document newDocument() {
        return this.db.newDocument();
    }

    public Document newDocumentMathMLDTD() {
        DocumentType documentType = this.db.getDOMImplementation().createDocumentType("math", "-//W3C//DTD MathML 2.0//EN", "http://www.w3.org/Math/DTD/mathml2/mathml2.dtd");
        Document document = this.db.getDOMImplementation().createDocument("http://www.w3.org/1998/Math/MathML", "math", documentType);
        return document;
    }

    public Document newDocumentMathMLDTD(String string) {
        DocumentType documentType = this.db.getDOMImplementation().createDocumentType("math", "-//W3C//DTD MathML 2.0//EN", string);
        Document document = this.db.getDOMImplementation().createDocument("http://www.w3.org/1998/Math/MathML", "math", documentType);
        return document;
    }

    public Document buildDocument(Node node) throws JepException {
        return this.buildDocument(node, false, this.db);
    }

    public Document buildDocument(Node node, boolean bl) throws JepException {
        return this.buildDocument(node, bl, this.db);
    }

    public Document buildDocument(Node node, boolean bl, DocumentBuilder documentBuilder) throws JepException {
        Document document = documentBuilder.newDocument();
        Element element = this.buildMathElement(node, document, bl);
        document.appendChild(element);
        return document;
    }

    public Document buildDocument(Node node, String string) throws JepException {
        return this.buildDocument(node, string, this.db);
    }

    public Document buildDocument(Node node, String string, DocumentBuilder documentBuilder) throws JepException {
        Document document = documentBuilder.newDocument();
        Element element = this.buildMathElement(node, document, string);
        document.appendChild(element);
        return document;
    }

    public Element buildMathElement(Node node, Document document, boolean bl) throws JepException {
        String string = this.getNamespacePrefix();
        this.setNamespacePrefix(null);
        Element element = document.createElement("math");
        if (bl) {
            element.setAttribute("xmlns", "http://www.w3.org/1998/Math/MathML");
        }
        Element element2 = this.buildChild(node, document);
        element.appendChild(element2);
        this.setNamespacePrefix(string);
        return element;
    }

    public Element buildMathElement(Node[] nodeArray, Document document, boolean bl) throws JepException {
        String string = this.getNamespacePrefix();
        this.setNamespacePrefix(null);
        Element element = document.createElement("math");
        if (bl) {
            element.setAttribute("xmlns", "http://www.w3.org/1998/Math/MathML");
        }
        for (Node node : nodeArray) {
            Element element2 = this.buildChild(node, document);
            element.appendChild(element2);
        }
        this.setNamespacePrefix(string);
        return element;
    }

    public Element buildMathElement(Node node, Document document, String string) throws JepException {
        String string2 = this.getNamespacePrefix();
        this.setNamespacePrefix(string);
        Element element = this.createElement("math", document);
        element.setAttribute("xmlns:" + string, "http://www.w3.org/1998/Math/MathML");
        Element element2 = this.buildChild(node, document);
        element.appendChild(element2);
        this.setNamespacePrefix(string2);
        return element;
    }

    public Element buildMathElement(Node[] nodeArray, Document document, String string) throws JepException {
        Element element = this.createElement("math", document);
        element.setAttribute("xmlns:" + string, "http://www.w3.org/1998/Math/MathML");
        String string2 = this.getNamespacePrefix();
        this.setNamespacePrefix(string);
        for (Node node : nodeArray) {
            Element element2 = this.buildChild(node, document);
            element.appendChild(element2);
        }
        this.setNamespacePrefix(string2);
        return element;
    }

    @Override
    public Element buildChild(Node node, Document document) throws JepException {
        if (node instanceof ASTConstant) {
            return this.numberBuilder.build(node, document, this);
        }
        if (node instanceof ASTVarNode) {
            return this.varibleBuilder.build(node, document, this);
        }
        if (node instanceof ASTOpNode) {
            return this.operatorBuilder.build(node, document, this);
        }
        if (node instanceof ASTFunNode) {
            return this.functionBuilder.build(node, document, this);
        }
        return null;
    }

    @Override
    public Element createElement(String string, Document document) {
        if (this.namespacePrefix != null) {
            Element element = document.createElementNS("http://www.w3.org/1998/Math/MathML", this.namespacePrefix + ":" + string);
            return element;
        }
        Element element = document.createElement(string);
        return element;
    }

    @Override
    public void setAttribute(Element element, String string, String string2) {
        if (this.namespacePrefix != null) {
            element.setAttributeNS("http://www.w3.org/1998/Math/MathML", this.namespacePrefix + ":" + string, string2);
        } else {
            element.setAttribute(string, string2);
        }
    }

    public NumberBuilder getNumberBuilder() {
        return this.numberBuilder;
    }

    public void setNumberBuilder(NumberBuilder numberBuilder) {
        this.numberBuilder = numberBuilder;
    }

    public VariableBuilder getVaribleBuilder() {
        return this.varibleBuilder;
    }

    public void setVaribleBuilder(VariableBuilder variableBuilder) {
        this.varibleBuilder = variableBuilder;
    }

    public String putConstant(String string, String string2) {
        return this.varibleBuilder.putConstant(string, string2);
    }

    public String putEntity(String string, String string2) {
        return this.varibleBuilder.putEntity(string, string2);
    }

    public MathMLFragmentBuilder putOperator(Operator operator, MathMLFragmentBuilder mathMLFragmentBuilder) {
        return this.operatorBuilder.put(operator, mathMLFragmentBuilder);
    }

    public String putOperator(Operator operator, String string) {
        return this.operatorBuilder.put(operator, string);
    }

    public MathMLFragmentBuilder putFunction(String string, MathMLFragmentBuilder mathMLFragmentBuilder) {
        return this.functionBuilder.putSpecialFunction(string, mathMLFragmentBuilder);
    }

    public String putFunction(String string, String string2) {
        return this.functionBuilder.putFunction(string, string2);
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return this.dbf;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.dbf = documentBuilderFactory;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(String string) {
        this.namespacePrefix = string;
    }

    public FunctionBuilder getFunctionBuilder() {
        return this.functionBuilder;
    }

    public void setFunctionBuilder(FunctionBuilder functionBuilder) {
        this.functionBuilder = functionBuilder;
    }

    public OperatorBuilder getOperatorBuilder() {
        return this.operatorBuilder;
    }

    public void setOperatorBuilder(OperatorBuilder operatorBuilder) {
        this.operatorBuilder = operatorBuilder;
    }

    public NumberBuilder.DoubleBehaviour getDoubleBehaviour() {
        return this.numberBuilder.getDoubleBehaviour();
    }

    public void setDoubleBehaviour(NumberBuilder.DoubleBehaviour doubleBehaviour) {
        this.numberBuilder.setDoubleBehaviour(doubleBehaviour);
    }
}

