/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.mathml.parser;

import com.singularsys.extensions.mathml.parser.AbstractHandler;
import com.singularsys.extensions.mathml.parser.FunctionElement;
import com.singularsys.extensions.mathml.parser.SpecialFunctionHandler;
import com.singularsys.extensions.mathml.parser.StackFrame;
import com.singularsys.jep.Jep;
import com.singularsys.jep.Operator;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.Node;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class ApplyHandler
extends AbstractHandler {
    public ApplyHandler(Jep jep) {
        super(jep);
    }

    @Override
    public Object handle(StackFrame stackFrame, Locator locator) throws SAXParseException {
        if (stackFrame.getNumChildren() < 1) {
            throw new SAXParseException("Element <apply> should have at least one child", locator);
        }
        Object object = stackFrame.getChild(0);
        int n = stackFrame.getNumChildren() - 1;
        if (object == null) {
            throw new SAXParseException("First child of <apply/> is null", locator);
        }
        if (object instanceof SpecialFunctionHandler) {
            try {
                Node node = ((SpecialFunctionHandler)object).apply(this, stackFrame, locator);
                return node;
            }
            catch (ParseException parseException) {
                throw new SAXParseException(parseException.getMessage(), locator, parseException);
            }
        }
        if (object instanceof Operator) {
            Operator operator = (Operator)object;
            if (!operator.getPFMC().checkNumberOfParameters(n)) {
                throw new SAXParseException("Invalid number of children (" + n + ")for operator " + operator.getName(), locator);
            }
            Node[] nodeArray = new Node[n];
            for (int i = 0; i < n; ++i) {
                nodeArray[i] = this.convertToNode(stackFrame, stackFrame.getChild(i + 1), locator);
            }
            try {
                ASTOpNode aSTOpNode = this.nf.buildOperatorNode(operator, nodeArray);
                return aSTOpNode;
            }
            catch (ParseException parseException) {
                throw new SAXParseException(parseException.getMessage(), locator, parseException);
            }
        }
        if (object instanceof FunctionElement) {
            FunctionElement functionElement = (FunctionElement)object;
            if (!functionElement.getPfmc().checkNumberOfParameters(n)) {
                throw new SAXParseException("Invalid number of children (" + n + ")for function " + functionElement.getName(), locator);
            }
            Node[] nodeArray = new Node[n];
            for (int i = 0; i < n; ++i) {
                nodeArray[i] = this.convertToNode(stackFrame, stackFrame.getChild(i + 1), locator);
            }
            try {
                ASTFunNode aSTFunNode = this.nf.buildFunctionNode(functionElement.getName(), functionElement.getPfmc(), nodeArray);
                return aSTFunNode;
            }
            catch (ParseException parseException) {
                throw new SAXParseException(parseException.getMessage(), locator, parseException);
            }
        }
        throw new SAXParseException("Currently only operator are supported for first arg of <apply> found: " + object.getClass().getSimpleName(), locator);
    }
}

