/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.mathml.parser;

import com.singularsys.extensions.mathml.parser.AbstractHandler;
import com.singularsys.extensions.mathml.parser.StackFrame;
import com.singularsys.extensions.mathml.parser.StartTagHandler;
import com.singularsys.jep.Jep;
import com.singularsys.jep.parser.Node;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MathTagHandler
extends AbstractHandler
implements StartTagHandler {
    List<Node> allResults = new ArrayList<Node>();
    boolean inMathTag = false;

    public MathTagHandler(Jep jep) {
        super(jep);
    }

    @Override
    public void start(StackFrame stackFrame, Locator locator) throws SAXParseException {
        if (this.inMathTag) {
            throw new SAXParseException("Doublely nested <math> tag.", locator);
        }
        this.inMathTag = true;
    }

    @Override
    public Object handle(StackFrame stackFrame, Locator locator) throws SAXParseException {
        if (!this.inMathTag) {
            throw new SAXParseException("Closing </math> tag without matching start tag.", locator);
        }
        this.inMathTag = false;
        List<Node> list = this.jepNodesToFlatList(stackFrame);
        this.allResults.addAll(list);
        return list;
    }

    @Override
    public void startDoc() {
        this.allResults.clear();
        this.inMathTag = false;
    }

    @Override
    public void endDoc() throws SAXException {
        if (this.inMathTag) {
            throw new SAXException("Unclosed <math> tag");
        }
    }

    public List<Node> getResults() {
        return this.allResults;
    }

    public boolean isInMathTag() {
        return this.inMathTag;
    }

    public void setInMathTag(boolean bl) {
        this.inMathTag = bl;
    }
}

