/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.doublemat;

import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixFactoryI;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.extensions.matrix.doublemat.DoubleMatrix;
import com.singularsys.extensions.matrix.doublemat.DoubleVector;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;

public class DoubleMatrixFactory
implements MatrixFactoryI {
    private static final long serialVersionUID = 350L;

    public DoubleMatrix newMatrix(double[][] dArray) {
        return new DoubleMatrix(dArray);
    }

    public DoubleVector newVector(double[] dArray) {
        return new DoubleVector(dArray);
    }

    @Override
    public MatrixI newMatrix(Object[][] objectArray) throws EvaluationException {
        int n = objectArray[0].length;
        double[][] dArray = new double[objectArray.length][n];
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!(objectArray[i][j] instanceof Number)) {
                    throw new EvaluationException("DoubleMatrix: all elements must be numbers " + objectArray[i][j]);
                }
                dArray[i][j] = ((Number)objectArray[i][j]).doubleValue();
            }
        }
        return this.newMatrix(dArray);
    }

    @Override
    public VectorI newVector(Object ... objectArray) throws EvaluationException {
        double[] dArray = new double[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Number)) continue;
            dArray[i] = ((Number)objectArray[i]).doubleValue();
        }
        return this.newVector(dArray);
    }

    @Override
    public Double elementValue(Object object) {
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return null;
    }

    @Override
    public MatrixI identity(int n) {
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = 1.0;
        }
        return new DoubleMatrix(dArray);
    }

    @Override
    public MatrixI identity(int n, int n2) {
        double[][] dArray = new double[n][n2];
        int n3 = n < n2 ? n : n2;
        for (int i = 0; i < n3; ++i) {
            dArray[i][i] = 1.0;
        }
        return new DoubleMatrix(dArray);
    }

    @Override
    public VectorI zeroVec(int n) {
        double[] dArray = new double[n];
        return new DoubleVector(dArray);
    }

    @Override
    public MatrixI zeroMat(int n, int n2) {
        double[][] dArray = new double[n][n2];
        return new DoubleMatrix(dArray);
    }

    @Override
    public MatrixI zeroMat(Dimensions dimensions) throws EvaluationException {
        if (dimensions.order() != 2) {
            throw new EvaluationException("Dimensions must be of order two, found" + dimensions);
        }
        return this.zeroMat(dimensions.getFirstDim(), dimensions.getLastDim());
    }

    @Override
    public void init(Jep jep) {
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return null;
    }
}

