/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.functions;

import com.singularsys.extensions.field.implementations.IntegerConvertor;
import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixFactoryI;
import com.singularsys.extensions.matrix.MatrixFunctionI;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.extensions.xjep.SymbolicLValueI;
import com.singularsys.extensions.xjep.XVariable;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.Variable;
import com.singularsys.jep.functions.Ele;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import java.text.MessageFormat;

public class MatrixEle
extends Ele
implements MatrixFunctionI,
SymbolicLValueI {
    private static final long serialVersionUID = 340L;
    MatrixFactoryI mfact;
    IntegerConvertor conv;
    NodeFactory nf;

    public MatrixEle(MatrixFactoryI matrixFactoryI, IntegerConvertor integerConvertor) {
        this.mfact = matrixFactoryI;
        this.conv = integerConvertor;
    }

    public MatrixEle(MatrixFactoryI matrixFactoryI, IntegerConvertor integerConvertor, boolean bl) {
        super(bl);
        this.mfact = matrixFactoryI;
        this.conv = integerConvertor;
    }

    int getIntValue(int n, Object object) throws EvaluationException {
        Integer n2 = this.conv.convertToInt(object);
        if (n2 == null) {
            n2 = this.asStrictInt(n, object);
        }
        return n2;
    }

    @Override
    public Object ele(Object object, Object object2) throws EvaluationException {
        if (object2 instanceof VectorI) {
            VectorI vectorI = (VectorI)object2;
            if (vectorI.getNEles() == 1) {
                return this.ele(object, vectorI.getEle(0));
            }
            if (vectorI.getNEles() == 2) {
                return this.ele(object, vectorI.getEle(0), vectorI.getEle(1));
            }
            throw new EvaluationException("Ele: too many arguments " + object2);
        }
        if (object instanceof VectorI) {
            VectorI vectorI = (VectorI)object;
            int n = this.getIntValue(1, object2) - this.indexShift;
            if (n >= vectorI.getNEles() || n < 0) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.IndexOutOfRange"), n + this.indexShift));
            }
            return vectorI.getEle(n);
        }
        if (object instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object;
            int n = this.getIntValue(1, object2) - this.indexShift;
            if (n >= matrixI.getNRows() || n < 0) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.IndexOutOfRange"), n + this.indexShift));
            }
            int n2 = matrixI.getNCols();
            VectorI vectorI = this.mfact.zeroVec(n2);
            for (int i = 0; i < n2; ++i) {
                vectorI.setEle(i, matrixI.getEle(n, i));
            }
            return vectorI;
        }
        return null;
    }

    @Override
    public Object ele(Object object, Object object2, Object object3) throws EvaluationException {
        if (object instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object;
            int n = this.getIntValue(1, object2) - this.indexShift;
            int n2 = this.getIntValue(2, object3) - this.indexShift;
            if (n >= matrixI.getNRows() || n < 0) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.IndexOutOfRange"), n + this.indexShift));
            }
            if (n2 >= matrixI.getNCols() || n2 < 0) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.IndexOutOfRange"), n2 + this.indexShift));
            }
            return matrixI.getEle(n, n2);
        }
        return null;
    }

    @Override
    public Object ele(Object object, Object[] objectArray) throws EvaluationException {
        throw new EvaluationException("Should not have been called");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Evaluator evaluator, Node node, Object object) throws EvaluationException {
        Node node2 = node.jjtGetChild(0);
        if (!(node2 instanceof ASTVarNode)) {
            throw new EvaluationException("Ele: lhs must be a variable");
        }
        Variable variable = node2.getVar();
        if (node.jjtGetNumChildren() == 2) {
            Object object2 = evaluator.eval(node.jjtGetChild(1));
            if (object2 instanceof Number || this.conv.convertToInt(object2) != null) {
                int n = this.getIntValue(2, object2) - this.indexShift;
                this.set(variable, n, object);
                return;
            } else {
                if (!(object2 instanceof VectorI)) throw new EvaluationException("Ele: rhs must be a number or vector");
                VectorI vectorI = (VectorI)object2;
                if (vectorI.getNEles() == 1) {
                    int n = this.getIntValue(1, vectorI.getEle(0)) - this.indexShift;
                    this.set(variable, n, object);
                    return;
                }
                if (vectorI.getNEles() != 2) return;
                int n = this.getIntValue(1, vectorI.getEle(0)) - this.indexShift;
                int n2 = this.getIntValue(2, vectorI.getEle(1)) - this.indexShift;
                this.set(variable, n, n2, object);
            }
            return;
        } else {
            if (node.jjtGetNumChildren() != 3) throw new EvaluationException("Ele: too many arguments ");
            Object object3 = evaluator.eval(node.jjtGetChild(1));
            Object object4 = evaluator.eval(node.jjtGetChild(2));
            int n = this.getIntValue(1, object3) - this.indexShift;
            int n3 = this.getIntValue(2, object4) - this.indexShift;
            this.set(variable, n, n3, object);
        }
    }

    private void set(Variable variable, int n, int n2, Object object) throws EvaluationException {
        Object object2 = variable.getValue();
        if (object2 instanceof MatrixI) {
            MatrixI matrixI = (MatrixI)object2;
            if (n >= matrixI.getNRows() || n < 0) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.IndexOutOfRange"), n + this.indexShift));
            }
            if (n2 >= matrixI.getNCols() || n2 < 0) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.IndexOutOfRange"), n2 + this.indexShift));
            }
        } else {
            throw new EvaluationException("Ele: variable must have a matrix value");
        }
        ((MatrixI)object2).setEle(n, n2, this.mfact.elementValue(object));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void set(Variable variable, int n, Object object) throws EvaluationException {
        Object object2 = variable.getValue();
        if (object2 instanceof VectorI) {
            VectorI vectorI = (VectorI)object2;
            if (n >= vectorI.getNEles() || n < 0) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.IndexOutOfRange"), n + this.indexShift));
            }
            ((VectorI)object2).setEle(n, this.mfact.elementValue(object));
            return;
        } else {
            if (!(object2 instanceof MatrixI)) throw new EvaluationException("Ele: variable must have a vector value");
            MatrixI matrixI = (MatrixI)object2;
            if (n > matrixI.getNRows() || n < 0) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.IndexOutOfRange"), n + this.indexShift));
            }
            if (!(object instanceof VectorI)) throw new EvaluationException("Expected vector value of RHS found " + object);
            VectorI vectorI = (VectorI)object;
            if (vectorI.getNEles() != matrixI.getNCols()) {
                throw new EvaluationException("Mismatch in dimensions " + matrixI.getDimensions() + " " + vectorI.getDimensions());
            }
            for (int i = 0; i < vectorI.getNEles(); ++i) {
                matrixI.setEle(n, i, vectorI.getEle(i));
            }
        }
    }

    @Override
    public Dimensions calcDims(Dimensions ... dimensionsArray) throws ParseException {
        int n = dimensionsArray.length;
        if (n < 2) {
            throw new ParseException(MessageFormat.format(JepMessages.getString("FunctionIllegalNumberOfArguments"), this.getName(), n));
        }
        Dimensions dimensions = dimensionsArray[0];
        Dimensions dimensions2 = dimensionsArray[1];
        if (dimensions.is0D()) {
            throw new ParseException("Element of operator can only be applied to vectors and matrices");
        }
        if (dimensions.is1D()) {
            if (!dimensions2.is0D()) {
                throw new ParseException("Element of operator, for vectors only number arguments are allowed.");
            }
            if (n != 2) {
                throw new ParseException("Element of operator, vectors can only have a single argument.");
            }
            return Dimensions.ONE;
        }
        if (dimensions.is2D()) {
            if (n == 3) {
                if (!dimensions2.is0D() || !dimensionsArray[2].is0D()) {
                    throw new ParseException("Element of operator, matrix[a][b] both a,b must be scalers.");
                }
                return Dimensions.ONE;
            }
            if (dimensions2.is0D()) {
                Dimensions dimensions3 = Dimensions.valueOf(dimensions.getLastDim());
                return dimensions3;
            }
            if (dimensions2.is1D()) {
                return Dimensions.ONE;
            }
            throw new ParseException("Element of operator, for matrices the argument must be a number or vector.");
        }
        throw new ParseException("Element of operator can only be applied to vectors and matrices");
    }

    @Override
    public void setEqn(Jep jep, Node node, Node node2) throws ParseException {
        block10: {
            Node node3 = node.jjtGetChild(0);
            if (!(node3 instanceof ASTVarNode)) {
                throw new ParseException("SetEle: lhs must be a variable");
            }
            XVariable xVariable = (XVariable)node3.getVar();
            if (!xVariable.hasEquation()) {
                throw new ParseException("SetEle: variable must have an equation.");
            }
            try {
                if (node.jjtGetNumChildren() == 2) {
                    Object object = jep.evaluate(node.jjtGetChild(1));
                    if (object instanceof Number || this.conv.convertToInt(object) != null) {
                        int n = this.getIntValue(2, object) - this.indexShift;
                        this.setEqn(xVariable, n, node2);
                        break block10;
                    }
                    if (object instanceof VectorI) {
                        VectorI vectorI = (VectorI)object;
                        if (vectorI.getNEles() == 1) {
                            int n = this.getIntValue(1, vectorI.getEle(0)) - this.indexShift;
                            this.setEqn(xVariable, n, node2);
                            return;
                        }
                        if (vectorI.getNEles() == 2) {
                            int n = this.getIntValue(1, vectorI.getEle(0)) - this.indexShift;
                            int n2 = this.getIntValue(2, vectorI.getEle(1)) - this.indexShift;
                            this.setEqn(xVariable, n, n2, node2);
                        }
                        break block10;
                    }
                    throw new ParseException("Ele: rhs must be a number or vector");
                }
                if (node.jjtGetNumChildren() == 3) {
                    Object object = jep.evaluate(node.jjtGetChild(1));
                    Object object2 = jep.evaluate(node.jjtGetChild(2));
                    int n = this.getIntValue(1, object) - this.indexShift;
                    int n3 = this.getIntValue(2, object2) - this.indexShift;
                    this.setEqn(xVariable, n, n3, node2);
                    break block10;
                }
                throw new ParseException("Ele: too many arguments ");
            }
            catch (EvaluationException evaluationException) {
                throw new ParseException(evaluationException);
            }
        }
    }

    private void setEqn(XVariable xVariable, int n, int n2, Node node) {
        Node node2 = xVariable.getEquation().jjtGetChild(n);
        node2.jjtAddChild(node, n2);
    }

    private void setEqn(XVariable xVariable, int n, Node node) {
        Node node2 = xVariable.getEquation();
        node2.jjtAddChild(node, n);
    }
}

