/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.functions;

import com.singularsys.extensions.ExtMessages;
import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixFactoryI;
import com.singularsys.extensions.matrix.MatrixFunctionI;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.extensions.matrix.doublemat.DoubleVector;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.NaryFunction;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.text.MessageFormat;
import java.util.Stack;

public class MatrixList
extends NaryFunction
implements MatrixFunctionI {
    private static final long serialVersionUID = 330L;
    MatrixFactoryI mf;

    public MatrixList(MatrixFactoryI matrixFactoryI) {
        super(-1);
        this.mf = matrixFactoryI;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n >= 1;
    }

    @Override
    public Object eval(Object[] objectArray) throws EvaluationException {
        int n = objectArray.length;
        if (objectArray[0] instanceof MatrixI) {
            throw new IllegalParameterException((PostfixMathCommandI)this, 0, VectorI.class, objectArray[0]);
        }
        if (objectArray[0] instanceof VectorI) {
            VectorI vectorI = (VectorI)objectArray[0];
            int n2 = vectorI.getNEles();
            Object[][] objectArray2 = new Object[n][n2];
            for (int i = 0; i < n; ++i) {
                if (!(objectArray[i] instanceof VectorI)) {
                    throw new IllegalParameterException((PostfixMathCommandI)this, i, VectorI.class, objectArray[i]);
                }
                VectorI vectorI2 = (VectorI)objectArray[i];
                if (vectorI2.getNEles() != n2) {
                    throw new EvaluationException("Lengths of vectors do not match " + n2 + ", " + vectorI2.getNEles());
                }
                for (int j = 0; j < n2; ++j) {
                    objectArray2[i][j] = this.mf.elementValue(((VectorI)objectArray[i]).getEle(j));
                }
            }
            MatrixI matrixI = this.mf.newMatrix(objectArray2);
            return matrixI;
        }
        Object[] objectArray3 = new Object[n];
        for (int i = 0; i < n; ++i) {
            if (objectArray[i] instanceof VectorI || objectArray[i] instanceof MatrixI) {
                throw new IllegalParameterException((PostfixMathCommand)this, i, objectArray[i]);
            }
            objectArray3[i] = this.mf.elementValue(objectArray[i]);
        }
        VectorI vectorI = this.mf.newVector(objectArray3);
        return vectorI;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        int n = this.curNumberOfParameters;
        Object object = stack.pop();
        if (object instanceof VectorI) {
            int n2;
            VectorI vectorI = (VectorI)object;
            int n3 = vectorI.getNEles();
            Object[][] objectArray = new Object[n][n3];
            for (n2 = 0; n2 < n3; ++n2) {
                objectArray[n - 1][n2] = this.mf.elementValue(vectorI.getEle(n2));
            }
            for (n2 = n - 2; n2 >= 0; --n2) {
                object = stack.pop();
                if (object instanceof VectorI) {
                    vectorI = (VectorI)object;
                    for (int i = 0; i < n3; ++i) {
                        objectArray[n2][i] = this.mf.elementValue(vectorI.getEle(i));
                    }
                    continue;
                }
                throw new IllegalParameterException((PostfixMathCommandI)this, n2, DoubleVector.class, object);
            }
            MatrixI matrixI = this.mf.newMatrix(objectArray);
            stack.push(matrixI);
        } else {
            Object[] objectArray = new Object[n];
            objectArray[n - 1] = object;
            for (int i = n - 2; i >= 0; --i) {
                object = stack.pop();
                objectArray[i] = this.mf.elementValue(object);
                VectorI vectorI = this.mf.newVector(objectArray);
                stack.push(vectorI);
            }
        }
    }

    @Override
    public Dimensions calcDims(Dimensions ... dimensionsArray) throws ParseException {
        int n = dimensionsArray.length;
        if (n <= 0) {
            throw new ParseException(MessageFormat.format(JepMessages.getString("FunctionIllegalNumberOfArguments"), this.getName(), n));
        }
        Dimensions dimensions = dimensionsArray[0];
        for (int i = 1; i < n; ++i) {
            if (dimensions.equalsDim(dimensionsArray[i])) continue;
            throw new ParseException(MessageFormat.format(ExtMessages.getString("DimensionMissmatch"), this.getName(), dimensions, dimensionsArray[i]));
        }
        if (dimensions.is0D()) {
            return Dimensions.valueOf(n);
        }
        if (dimensions.is1D()) {
            return Dimensions.valueOf(n, dimensions.getFirstDim());
        }
        return Dimensions.valueOf(n, dimensions);
    }
}

