/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.functions;

import com.singularsys.extensions.field.implementations.IntegerConvertor;
import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixFactoryI;
import com.singularsys.extensions.matrix.MatrixFunctionI;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.functions.UnaryFunction;
import java.text.MessageFormat;

public class MatrixSize
extends UnaryFunction
implements MatrixFunctionI {
    private static final long serialVersionUID = 340L;
    MatrixFactoryI mfact;
    IntegerConvertor conv;

    public MatrixSize(MatrixFactoryI matrixFactoryI, IntegerConvertor integerConvertor) {
        this.mfact = matrixFactoryI;
        this.conv = integerConvertor;
    }

    @Override
    public Object eval(Object object) throws EvaluationException {
        if (object instanceof MatrixI) {
            int n = ((MatrixI)object).getNRows();
            int n2 = ((MatrixI)object).getNCols();
            return this.mfact.newVector(this.conv.convertFromInt(n), this.conv.convertFromInt(n2));
        }
        if (object instanceof VectorI) {
            return this.conv.convertFromInt(((VectorI)object).getNEles());
        }
        return this.mfact.elementValue(1.0);
    }

    @Override
    public Dimensions calcDims(Dimensions ... dimensionsArray) throws ParseException {
        if (dimensionsArray.length != 1) {
            throw new ParseException(MessageFormat.format(JepMessages.getString("FunctionRequiresNArgumentsFoundN"), this.getName(), 1, dimensionsArray.length));
        }
        Dimensions dimensions = dimensionsArray[0];
        int n = dimensions.order();
        return Dimensions.valueOf(n);
    }
}

