/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.genericmat;

import com.singularsys.extensions.field.implementations.GenericField;
import com.singularsys.extensions.field.implementations.GenericPowerField;
import com.singularsys.extensions.matrix.MatrixFactoryI;
import com.singularsys.extensions.matrix.genericmat.GenericMatrixFactory;
import com.singularsys.extensions.matrix.genericmat.GenericMatrixField;
import com.singularsys.jep.EvaluationException;

public class GenericFieldMatrixField<E>
extends GenericMatrixField<E> {
    private static final long serialVersionUID = 350L;
    protected GenericField<E> base;

    public GenericFieldMatrixField(GenericMatrixFactory<E> genericMatrixFactory, GenericField<E> genericField) {
        super(genericMatrixFactory);
        this.base = genericField;
    }

    public GenericFieldMatrixField(MatrixFactoryI matrixFactoryI, GenericField<E> genericField) {
        this((GenericMatrixFactory)matrixFactoryI, genericField);
    }

    public GenericFieldMatrixField(GenericMatrixFactory<E> genericMatrixFactory, GenericPowerField<E> genericPowerField, boolean bl) {
        super(genericMatrixFactory, bl);
        this.base = genericPowerField;
    }

    @Override
    protected E addEle(E e, E e2) throws EvaluationException {
        try {
            return this.base.addG(e, e2);
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvaluationException(arithmeticException);
        }
    }

    @Override
    protected E subEle(E e, E e2) throws EvaluationException {
        try {
            return this.base.subG(e, e2);
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvaluationException(arithmeticException);
        }
    }

    @Override
    protected E negEle(E e) throws EvaluationException {
        try {
            return this.base.negG(e);
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvaluationException(arithmeticException);
        }
    }

    @Override
    protected E mulEle(E e, E e2) throws EvaluationException {
        try {
            return this.base.mulG(e, e2);
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvaluationException(arithmeticException);
        }
    }

    @Override
    protected E modEle(E e, E e2) throws EvaluationException {
        try {
            return this.base.modG(e, e2);
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvaluationException(arithmeticException);
        }
    }

    @Override
    protected E divEle(E e, E e2) throws EvaluationException {
        try {
            return this.base.divG(e, e2);
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvaluationException(arithmeticException);
        }
    }

    @Override
    protected E powEle(E e, E e2) throws EvaluationException {
        try {
            return this.base.powG(e, e2);
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvaluationException(arithmeticException);
        }
    }

    @Override
    protected Boolean eqEle(E e, E e2) throws EvaluationException {
        Integer n = this.base.cmp(e, e2);
        if (n == null) {
            return null;
        }
        return n == 0;
    }

    @Override
    public Boolean neEle(E e, E e2) throws EvaluationException {
        Integer n = this.base.cmp(e, e2);
        if (n == null) {
            return null;
        }
        return n != 0;
    }

    @Override
    public Boolean gtEle(E e, E e2) throws EvaluationException {
        Integer n = this.base.cmp(e, e2);
        if (n == null) {
            return null;
        }
        return n > 0;
    }

    @Override
    public Boolean geEle(E e, E e2) throws EvaluationException {
        Integer n = this.base.cmp(e, e2);
        if (n == null) {
            return null;
        }
        return n >= 0;
    }

    @Override
    public Boolean ltEle(E e, E e2) throws EvaluationException {
        Integer n = this.base.cmp(e, e2);
        if (n == null) {
            return null;
        }
        return n < 0;
    }

    @Override
    public Boolean leEle(E e, E e2) throws EvaluationException {
        Integer n = this.base.cmp(e, e2);
        if (n == null) {
            return null;
        }
        return n <= 0;
    }

    @Override
    protected Boolean andEle(E e, E e2) throws EvaluationException {
        return this.base.and(e, e2);
    }

    @Override
    protected Boolean orEle(E e, E e2) throws EvaluationException {
        return this.base.or(e, e2);
    }

    @Override
    protected Boolean notEle(E e) throws EvaluationException {
        return this.base.not(e);
    }

    @Override
    public E getZero() {
        return this.base.getZero();
    }

    @Override
    public E getOne() {
        return this.base.getOne();
    }

    @Override
    public Object convertFromInt(Integer n) throws EvaluationException {
        return this.base.convertFromInt(n);
    }

    @Override
    public Integer convertToInt(Object object) throws EvaluationException {
        return this.base.convertToInt(object);
    }
}

