/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.genericmat;

import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.jep.EvaluationException;
import java.util.Arrays;

public class GenericMatrix<E>
implements MatrixI {
    protected final Object[][] data;
    final int nrows;
    final int ncols;

    protected GenericMatrix(Object[][] objectArray) {
        this.data = objectArray;
        this.nrows = objectArray.length;
        this.ncols = objectArray[0].length;
    }

    public final E getEle(int n, int n2) {
        return (E)this.data[n][n2];
    }

    public final void setEleG(int n, int n2, E e) throws EvaluationException {
        if (e == null) {
            throw new EvaluationException("Could not set element " + n + ", " + n2 + " wrong type. Found " + e);
        }
        this.data[n][n2] = e;
    }

    @Override
    public void setEle(int n, int n2, Object object) throws EvaluationException {
        this.setEleG(n, n2, object);
    }

    @Override
    public final int getNCols() {
        return this.ncols;
    }

    @Override
    public final int getNRows() {
        return this.nrows;
    }

    @Override
    public Dimensions getDimensions() {
        return Dimensions.valueOf(this.nrows, this.ncols);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (object instanceof GenericMatrix) {
            GenericMatrix genericMatrix = (GenericMatrix)object;
            return Arrays.equals((Object[])this.data, (Object[])genericMatrix.data);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode((Object[])this.data);
    }

    public String toString() {
        return Arrays.deepToString((Object[])this.data);
    }

    @Override
    public Object[][] toArray(Object[][] objectArray) throws EvaluationException {
        if (objectArray == null || objectArray.length != this.nrows || objectArray[0].length != this.ncols) {
            throw new EvaluationException("Null matrix or matrix of wrong size.");
        }
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                objectArray[i][j] = this.data[i][j];
            }
        }
        return objectArray;
    }
}

