/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.genericmat;

import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.jep.EvaluationException;
import java.text.MessageFormat;
import java.util.Arrays;

public class GenericVector<E>
implements VectorI {
    protected final Object[] data;
    final int nrows;

    public GenericVector(Object[] objectArray) {
        this.data = objectArray;
        this.nrows = objectArray.length;
    }

    public E getEle(int n) {
        return (E)this.data[n];
    }

    public void setEleG(int n, E e) throws EvaluationException {
        if (e == null) {
            throw new EvaluationException("Could not set element " + n + " wrong type. Found " + e);
        }
        this.data[n] = e;
        this.data[n] = e;
    }

    @Override
    public void setEle(int n, Object object) throws EvaluationException {
        this.setEleG(n, object);
    }

    @Override
    public int getNEles() {
        return this.nrows;
    }

    @Override
    public Dimensions getDimensions() {
        return Dimensions.valueOf(this.nrows);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (object instanceof GenericVector) {
            GenericVector genericVector = (GenericVector)object;
            return Arrays.equals(this.data, genericVector.data);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    @Override
    public Object[] toArray(Object[] objectArray) throws EvaluationException {
        if (objectArray == null) {
            throw new EvaluationException("DoubleVector.toArray null vector");
        }
        if (objectArray.length != this.nrows) {
            throw new EvaluationException(MessageFormat.format("DoubleVector.toArray wrong size for supplied vector expected {0} got {1}", this.nrows, objectArray.length));
        }
        for (int i = 0; i < this.nrows; ++i) {
            objectArray[i] = this.data[i];
        }
        return objectArray;
    }
}

