/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.sequencemat;

import com.singularsys.extensions.matrix.AbstractMatrixField;
import com.singularsys.extensions.matrix.MatrixFactoryI;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.extensions.matrix.doublemat.DoubleVector;
import com.singularsys.extensions.matrix.sequencemat.SequenceMatrix;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.functions.Power;

public class SequenceMatrixField
extends AbstractMatrixField {
    private static final long serialVersionUID = 330L;
    Power pow = new Power();

    public SequenceMatrixField(MatrixFactoryI matrixFactoryI) {
        super(matrixFactoryI);
    }

    @Override
    protected MatrixI addMM(MatrixI matrixI, MatrixI matrixI2) {
        SequenceMatrix sequenceMatrix = (SequenceMatrix)matrixI;
        SequenceMatrix sequenceMatrix2 = (SequenceMatrix)matrixI2;
        int n = sequenceMatrix.nrows * sequenceMatrix.ncols;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < sequenceMatrix.ncols; ++j) {
                dArray[i] = sequenceMatrix.data[i] + sequenceMatrix2.data[i];
            }
        }
        SequenceMatrix sequenceMatrix3 = new SequenceMatrix(dArray, sequenceMatrix.nrows, sequenceMatrix.ncols);
        return sequenceMatrix3;
    }

    @Override
    protected MatrixI subMM(MatrixI matrixI, MatrixI matrixI2) {
        SequenceMatrix sequenceMatrix = (SequenceMatrix)matrixI;
        SequenceMatrix sequenceMatrix2 = (SequenceMatrix)matrixI2;
        int n = sequenceMatrix.nrows * sequenceMatrix.ncols;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < sequenceMatrix.ncols; ++j) {
                dArray[i] = sequenceMatrix.data[i] - sequenceMatrix2.data[i];
            }
        }
        SequenceMatrix sequenceMatrix3 = new SequenceMatrix(dArray, sequenceMatrix.nrows, sequenceMatrix.ncols);
        return sequenceMatrix3;
    }

    @Override
    protected MatrixI negM(MatrixI matrixI) {
        SequenceMatrix sequenceMatrix = (SequenceMatrix)matrixI;
        int n = sequenceMatrix.nrows * sequenceMatrix.ncols;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < sequenceMatrix.ncols; ++j) {
                dArray[i] = -sequenceMatrix.data[i];
            }
        }
        SequenceMatrix sequenceMatrix2 = new SequenceMatrix(dArray, sequenceMatrix.nrows, sequenceMatrix.ncols);
        return sequenceMatrix2;
    }

    @Override
    protected SequenceMatrix mulMO(MatrixI matrixI, Object object) {
        SequenceMatrix sequenceMatrix = (SequenceMatrix)matrixI;
        double d = ((Number)object).doubleValue();
        int n = sequenceMatrix.nrows * sequenceMatrix.ncols;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < sequenceMatrix.ncols; ++j) {
                dArray[i] = sequenceMatrix.data[i] * d;
            }
        }
        SequenceMatrix sequenceMatrix2 = new SequenceMatrix(dArray, sequenceMatrix.nrows, sequenceMatrix.ncols);
        return sequenceMatrix2;
    }

    @Override
    protected SequenceMatrix mulMM(MatrixI matrixI, MatrixI matrixI2) {
        SequenceMatrix sequenceMatrix = (SequenceMatrix)matrixI;
        SequenceMatrix sequenceMatrix2 = (SequenceMatrix)matrixI2;
        double[] dArray = new double[sequenceMatrix.nrows * sequenceMatrix2.ncols];
        for (int i = 0; i < sequenceMatrix.nrows; ++i) {
            for (int j = 0; j < sequenceMatrix2.ncols; ++j) {
                double d = 0.0;
                for (int k = 0; k < sequenceMatrix.ncols; ++k) {
                    d += sequenceMatrix.data[i * sequenceMatrix.ncols + k] * sequenceMatrix2.data[k * sequenceMatrix2.ncols + j];
                }
                dArray[i * sequenceMatrix2.ncols + j] = d;
            }
        }
        SequenceMatrix sequenceMatrix3 = new SequenceMatrix(dArray, sequenceMatrix.nrows, sequenceMatrix2.ncols);
        return sequenceMatrix3;
    }

    @Override
    protected DoubleVector mulVM(VectorI vectorI, MatrixI matrixI) {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        SequenceMatrix sequenceMatrix = (SequenceMatrix)matrixI;
        double[] dArray = new double[sequenceMatrix.ncols];
        for (int i = 0; i < sequenceMatrix.ncols; ++i) {
            double d = 0.0;
            for (int j = 0; j < sequenceMatrix.nrows; ++j) {
                d += doubleVector.data[j] * sequenceMatrix.data[j * sequenceMatrix.ncols + i];
            }
            dArray[i] = d;
        }
        DoubleVector doubleVector2 = new DoubleVector(dArray);
        return doubleVector2;
    }

    @Override
    protected DoubleVector mulMV(MatrixI matrixI, VectorI vectorI) {
        SequenceMatrix sequenceMatrix = (SequenceMatrix)matrixI;
        DoubleVector doubleVector = (DoubleVector)vectorI;
        double[] dArray = new double[sequenceMatrix.nrows];
        for (int i = 0; i < sequenceMatrix.nrows; ++i) {
            double d = 0.0;
            for (int j = 0; j < sequenceMatrix.ncols; ++j) {
                d += sequenceMatrix.data[i * sequenceMatrix.ncols + j] * doubleVector.data[j];
            }
            dArray[i] = d;
        }
        DoubleVector doubleVector2 = new DoubleVector(dArray);
        return doubleVector2;
    }

    @Override
    protected SequenceMatrix divMO(MatrixI matrixI, Object object) {
        SequenceMatrix sequenceMatrix = (SequenceMatrix)matrixI;
        double d = ((Number)object).doubleValue();
        int n = sequenceMatrix.nrows * sequenceMatrix.ncols;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < sequenceMatrix.ncols; ++j) {
                dArray[i] = sequenceMatrix.data[i] / d;
            }
        }
        SequenceMatrix sequenceMatrix2 = new SequenceMatrix(dArray, sequenceMatrix.nrows, sequenceMatrix.ncols);
        return sequenceMatrix2;
    }

    @Override
    protected Object detM(MatrixI matrixI) throws EvaluationException {
        SequenceMatrix sequenceMatrix = (SequenceMatrix)matrixI;
        if (sequenceMatrix.nrows == 2) {
            double d = sequenceMatrix.data[0] * sequenceMatrix.data[3] - sequenceMatrix.data[1] * sequenceMatrix.data[2];
            return d;
        }
        if (sequenceMatrix.nrows == 3) {
            double d = sequenceMatrix.data[0] * (sequenceMatrix.data[4] * sequenceMatrix.data[8] - sequenceMatrix.data[7] * sequenceMatrix.data[5]);
            d -= sequenceMatrix.data[1] * (sequenceMatrix.data[3] * sequenceMatrix.data[8] - sequenceMatrix.data[6] * sequenceMatrix.data[5]);
            return d += sequenceMatrix.data[2] * (sequenceMatrix.data[3] * sequenceMatrix.data[7] - sequenceMatrix.data[6] * sequenceMatrix.data[4]);
        }
        double d = 0.0;
        for (int i = 0; i < sequenceMatrix.ncols; ++i) {
            SequenceMatrix sequenceMatrix2 = (SequenceMatrix)this.minor(sequenceMatrix, 0, i);
            if (i % 2 == 0) {
                d += sequenceMatrix.data[i] * (Double)this.detM(sequenceMatrix2);
                continue;
            }
            d -= sequenceMatrix.data[i] * (Double)this.detM(sequenceMatrix2);
        }
        return d;
    }

    @Override
    protected Object transM(MatrixI matrixI) {
        SequenceMatrix sequenceMatrix = (SequenceMatrix)matrixI;
        double[] dArray = new double[sequenceMatrix.ncols * sequenceMatrix.nrows];
        int n = 0;
        for (int i = 0; i < sequenceMatrix.nrows; ++i) {
            for (int j = 0; j < sequenceMatrix.ncols; ++j) {
                dArray[j * sequenceMatrix.nrows + i] = sequenceMatrix.data[n++];
            }
        }
        return new SequenceMatrix(dArray, sequenceMatrix.ncols, sequenceMatrix.nrows);
    }

    @Override
    protected VectorI addVV(VectorI vectorI, VectorI vectorI2) {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        DoubleVector doubleVector2 = (DoubleVector)vectorI2;
        double[] dArray = new double[doubleVector.nrows];
        for (int i = 0; i < doubleVector.nrows; ++i) {
            dArray[i] = doubleVector.data[i] + doubleVector2.data[i];
        }
        DoubleVector doubleVector3 = new DoubleVector(dArray);
        return doubleVector3;
    }

    @Override
    protected VectorI subVV(VectorI vectorI, VectorI vectorI2) {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        DoubleVector doubleVector2 = (DoubleVector)vectorI2;
        double[] dArray = new double[doubleVector.nrows];
        for (int i = 0; i < doubleVector.nrows; ++i) {
            dArray[i] = doubleVector.data[i] - doubleVector2.data[i];
        }
        DoubleVector doubleVector3 = new DoubleVector(dArray);
        return doubleVector3;
    }

    @Override
    protected VectorI negV(VectorI vectorI) {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        double[] dArray = new double[doubleVector.nrows];
        for (int i = 0; i < doubleVector.nrows; ++i) {
            dArray[i] = -doubleVector.data[i];
        }
        DoubleVector doubleVector2 = new DoubleVector(dArray);
        return doubleVector2;
    }

    @Override
    protected VectorI mulVO(VectorI vectorI, Object object) {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        double d = ((Number)object).doubleValue();
        double[] dArray = new double[doubleVector.nrows];
        for (int i = 0; i < doubleVector.nrows; ++i) {
            dArray[i] = doubleVector.data[i] * d;
        }
        DoubleVector doubleVector2 = new DoubleVector(dArray);
        return doubleVector2;
    }

    @Override
    protected VectorI divVO(VectorI vectorI, Object object) {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        double d = ((Number)object).doubleValue();
        double[] dArray = new double[doubleVector.nrows];
        for (int i = 0; i < doubleVector.nrows; ++i) {
            dArray[i] = doubleVector.data[i] / d;
        }
        DoubleVector doubleVector2 = new DoubleVector(dArray);
        return doubleVector2;
    }

    @Override
    protected Object addEle(Object object, Object object2) {
        return (Double)object + (Double)object2;
    }

    @Override
    protected Object mulEle(Object object, Object object2) {
        return (Double)object * (Double)object2;
    }

    @Override
    protected Object subEle(Object object, Object object2) {
        return (Double)object - (Double)object2;
    }

    @Override
    protected Object dotVV(VectorI vectorI, VectorI vectorI2) throws EvaluationException {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        DoubleVector doubleVector2 = (DoubleVector)vectorI2;
        double d = 0.0;
        for (int i = 0; i < doubleVector.nrows; ++i) {
            d += doubleVector.data[i] * doubleVector2.data[i];
        }
        return d;
    }

    @Override
    protected MatrixI mulVV(VectorI vectorI, VectorI vectorI2) throws EvaluationException {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        DoubleVector doubleVector2 = (DoubleVector)vectorI2;
        double[] dArray = new double[doubleVector.nrows * doubleVector2.nrows];
        for (int i = 0; i < doubleVector.nrows; ++i) {
            for (int j = 0; j < doubleVector2.nrows; ++j) {
                dArray[i * doubleVector2.nrows + j] = doubleVector.data[i] * doubleVector2.data[j];
            }
        }
        return new SequenceMatrix(dArray, doubleVector.nrows, doubleVector2.nrows);
    }

    @Override
    protected Object crossVV(VectorI vectorI, VectorI vectorI2) throws EvaluationException {
        DoubleVector doubleVector = (DoubleVector)vectorI;
        DoubleVector doubleVector2 = (DoubleVector)vectorI2;
        if (doubleVector.nrows == 3) {
            double[] dArray = new double[]{doubleVector.data[1] * doubleVector2.data[2] - doubleVector.data[2] * doubleVector2.data[1], doubleVector.data[2] * doubleVector2.data[0] - doubleVector.data[0] * doubleVector2.data[2], doubleVector.data[0] * doubleVector2.data[1] - doubleVector.data[1] * doubleVector2.data[0]};
            DoubleVector doubleVector3 = new DoubleVector(dArray);
            return doubleVector3;
        }
        throw new EvaluationException("Wrong dimensions for cross product " + doubleVector.getNEles());
    }

    @Override
    protected Boolean eqVV(VectorI vectorI, VectorI vectorI2) throws EvaluationException {
        if (vectorI.getNEles() != vectorI2.getNEles()) {
            return Boolean.FALSE;
        }
        DoubleVector doubleVector = (DoubleVector)vectorI;
        DoubleVector doubleVector2 = (DoubleVector)vectorI2;
        for (int i = doubleVector.getNEles() - 1; i >= 0; --i) {
            if (doubleVector.data[i] == doubleVector2.data[i]) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    protected Boolean neVV(VectorI vectorI, VectorI vectorI2) throws EvaluationException {
        if (vectorI.getNEles() != vectorI2.getNEles()) {
            return Boolean.FALSE;
        }
        DoubleVector doubleVector = (DoubleVector)vectorI;
        DoubleVector doubleVector2 = (DoubleVector)vectorI2;
        for (int i = doubleVector.getNEles() - 1; i >= 0; --i) {
            if (doubleVector.data[i] == doubleVector2.data[i]) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    protected Boolean eqMM(MatrixI matrixI, MatrixI matrixI2) throws EvaluationException {
        SequenceMatrix sequenceMatrix = (SequenceMatrix)matrixI;
        SequenceMatrix sequenceMatrix2 = (SequenceMatrix)matrixI2;
        if (sequenceMatrix.nrows != sequenceMatrix2.nrows) {
            return false;
        }
        for (int i = 0; i < sequenceMatrix.nrows * sequenceMatrix.ncols; ++i) {
            if (sequenceMatrix.data[i] == sequenceMatrix2.data[i]) continue;
            return false;
        }
        return Boolean.TRUE;
    }

    @Override
    protected Boolean neMM(MatrixI matrixI, MatrixI matrixI2) throws EvaluationException {
        SequenceMatrix sequenceMatrix = (SequenceMatrix)matrixI;
        SequenceMatrix sequenceMatrix2 = (SequenceMatrix)matrixI2;
        if (sequenceMatrix.nrows != sequenceMatrix2.nrows) {
            return false;
        }
        for (int i = 0; i < sequenceMatrix.nrows * sequenceMatrix.ncols; ++i) {
            if (sequenceMatrix.data[i] == sequenceMatrix2.data[i]) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Object trace(Object object) throws EvaluationException {
        SequenceMatrix sequenceMatrix = (SequenceMatrix)object;
        int n = sequenceMatrix.nrows < sequenceMatrix.ncols ? sequenceMatrix.nrows : sequenceMatrix.ncols;
        double d = sequenceMatrix.data[0];
        for (int i = 1; i < n; ++i) {
            d += sequenceMatrix.data[i * sequenceMatrix.ncols + i];
        }
        return d;
    }

    @Override
    protected Object negEle(Object object) throws EvaluationException {
        return -((Double)object).doubleValue();
    }

    @Override
    protected Object divEle(Object object, Object object2) throws EvaluationException {
        return (Double)object / (Double)object2;
    }

    @Override
    protected Object modEle(Object object, Object object2) throws EvaluationException {
        return (Double)object % (Double)object2;
    }

    @Override
    protected Object powEle(Object object, Object object2) throws EvaluationException {
        return this.pow.power(object, object2);
    }

    @Override
    protected Boolean eqEle(Object object, Object object2) throws EvaluationException {
        return ((Double)object).doubleValue() == ((Double)object2).doubleValue();
    }

    @Override
    protected Boolean neEle(Object object, Object object2) throws EvaluationException {
        return ((Double)object).doubleValue() != ((Double)object2).doubleValue();
    }

    @Override
    protected Boolean leEle(Object object, Object object2) throws EvaluationException {
        return (Double)object <= (Double)object2;
    }

    @Override
    protected Boolean ltEle(Object object, Object object2) throws EvaluationException {
        return (Double)object < (Double)object2;
    }

    @Override
    protected Boolean geEle(Object object, Object object2) throws EvaluationException {
        return (Double)object >= (Double)object2;
    }

    @Override
    protected Boolean gtEle(Object object, Object object2) throws EvaluationException {
        return (Double)object > (Double)object2;
    }

    @Override
    protected Boolean andEle(Object object, Object object2) throws EvaluationException {
        return null;
    }

    @Override
    protected Boolean orEle(Object object, Object object2) throws EvaluationException {
        return null;
    }

    @Override
    protected Boolean notEle(Object object) throws EvaluationException {
        return null;
    }

    @Override
    public Object getOne() {
        return 1.0;
    }

    @Override
    public Object getZero() {
        return 0.0;
    }

    @Override
    public Integer convertToInt(Object object) throws EvaluationException {
        Double d;
        int n;
        if (object instanceof Double && (double)(n = (d = (Double)object).intValue()) == d) {
            return n;
        }
        return null;
    }

    @Override
    public Object convertFromInt(Integer n) throws EvaluationException {
        return n.doubleValue();
    }

    @Override
    public void init(Jep jep) {
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return null;
    }
}

