/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.polynomials;

import com.singularsys.extensions.polynomials.Monomial;
import com.singularsys.extensions.polynomials.PConstant;
import com.singularsys.extensions.polynomials.PNodeI;
import com.singularsys.extensions.polynomials.PolynomialCreator;
import com.singularsys.jep.ParseException;

public class MutableMonomial {
    PolynomialCreator pc;
    PConstant coeff;
    int length;
    PNodeI[] terms;
    PNodeI[] powers;

    public MutableMonomial(PolynomialCreator polynomialCreator, PConstant pConstant, PNodeI[] pNodeIArray, PNodeI[] pNodeIArray2) {
        this.pc = polynomialCreator;
        this.coeff = pConstant;
        this.length = pNodeIArray.length;
        this.terms = pNodeIArray;
        this.powers = pNodeIArray2;
    }

    public void mul(PConstant pConstant) throws ParseException {
        this.coeff = (PConstant)this.coeff.mul(pConstant);
    }

    public void div(PConstant pConstant) throws ParseException {
        this.coeff = (PConstant)this.coeff.div(pConstant);
    }

    public void mul(PNodeI pNodeI, PNodeI pNodeI2) throws ParseException {
        for (int i = 0; i < this.length; ++i) {
            if (!this.terms[i].equalsPNode(pNodeI)) continue;
            this.powers[i] = this.powers[i].add(pNodeI2);
            return;
        }
        PNodeI[] pNodeIArray = new PNodeI[this.length + 1];
        PNodeI[] pNodeIArray2 = new PNodeI[this.length + 1];
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < this.length; ++i) {
            if (!bl && this.terms[i].compareTo(pNodeI) > 0) {
                pNodeIArray[n] = pNodeI;
                pNodeIArray2[n] = pNodeI2;
                ++n;
                bl = true;
            }
            pNodeIArray[n] = this.terms[i];
            pNodeIArray2[n] = this.powers[i];
            ++n;
        }
        if (!bl) {
            pNodeIArray[n] = pNodeI;
            pNodeIArray2[n] = pNodeI2;
            ++n;
        }
        ++this.length;
        this.terms = pNodeIArray;
        this.powers = pNodeIArray2;
    }

    void power(PConstant pConstant) throws ParseException {
        this.coeff = (PConstant)this.coeff.pow(pConstant);
        for (int i = 0; i < this.length; ++i) {
            this.powers[i] = this.powers[i].mul(pConstant);
        }
    }

    private void reduce() throws ParseException {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.length; ++n) {
            if (this.powers[n].isZero()) {
                ++n2;
                continue;
            }
            if (this.terms[n].isOne()) {
                ++n3;
                continue;
            }
            if (!(this.terms[n] instanceof PConstant) || !(this.powers[n] instanceof PConstant)) continue;
            ++n4;
        }
        if (n2 == 0 && n3 == 0 && n4 == 0) {
            return;
        }
        n = this.length - n2 - n3 - n4;
        PNodeI[] pNodeIArray = new PNodeI[n];
        PNodeI[] pNodeIArray2 = new PNodeI[n];
        int n5 = 0;
        for (int i = 0; i < this.length; ++i) {
            if (this.powers[i].isZero() || this.terms[i].isOne()) continue;
            if (this.terms[i] instanceof PConstant && this.powers[i] instanceof PConstant) {
                this.coeff = (PConstant)this.coeff.mul(this.terms[i].pow(this.powers[i]));
                continue;
            }
            pNodeIArray[n5] = this.terms[i];
            pNodeIArray2[n5] = this.powers[i];
            ++n5;
        }
        this.length = n;
        this.terms = pNodeIArray;
        this.powers = pNodeIArray2;
    }

    PNodeI toPNode() throws ParseException {
        this.reduce();
        if (this.length == 0) {
            return this.coeff;
        }
        if (this.coeff.isZero()) {
            return this.pc.zeroConstant;
        }
        if (this.coeff.isOne() && this.length == 1 && this.powers[0].isOne()) {
            return this.terms[0];
        }
        return Monomial.valueOf(this.pc, this.coeff, this.terms, this.powers);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.coeff.toString());
        for (int i = 0; i < this.length; ++i) {
            stringBuffer.append(this.terms[i]);
            stringBuffer.append('^');
            stringBuffer.append(this.powers[i]);
        }
        return stringBuffer.toString();
    }
}

