/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.polynomials;

import com.singularsys.extensions.polynomials.AbstractPNode;
import com.singularsys.extensions.polynomials.Monomial;
import com.singularsys.extensions.polynomials.PNodeI;
import com.singularsys.extensions.polynomials.PolynomialCreator;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.Node;
import java.util.Map;

public class PFunction
extends AbstractPNode {
    String name;
    PostfixMathCommandI pfmc;
    PNodeI[] args;

    public PFunction(PolynomialCreator polynomialCreator, String string, PostfixMathCommandI postfixMathCommandI, PNodeI[] pNodeIArray) {
        super(polynomialCreator);
        this.name = string;
        this.pfmc = postfixMathCommandI;
        this.args = pNodeIArray;
    }

    @Override
    public boolean equalsPNode(PNodeI pNodeI) {
        if (!(pNodeI instanceof PFunction)) {
            return false;
        }
        PFunction pFunction = (PFunction)pNodeI;
        if (!this.name.equals(pFunction.name)) {
            return false;
        }
        if (this.args.length != pFunction.args.length) {
            return false;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].equalsPNode(pFunction.args[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(PFunction pFunction) {
        int n = this.name.compareTo(pFunction.name);
        if (n != 0) {
            return n;
        }
        if (this.args.length < pFunction.args.length) {
            return -1;
        }
        if (this.args.length > pFunction.args.length) {
            return 1;
        }
        for (int i = 0; i < this.args.length; ++i) {
            n = this.args[i].compareTo(pFunction.args[i]);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.args[i].toString());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public Node toNode() throws ParseException {
        Node[] nodeArray = new Node[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            nodeArray[i] = this.args[i].toNode();
        }
        ASTFunNode aSTFunNode = this.pc.getNodeFactory().buildFunctionNode(this.name, this.pfmc, nodeArray);
        return aSTFunNode;
    }

    @Override
    public Node toCompactNode() throws ParseException {
        return this.toNode();
    }

    @Override
    public PNodeI expand() throws ParseException {
        PNodeI[] pNodeIArray = new PNodeI[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            pNodeIArray[i] = this.args[i].expand();
        }
        return new PFunction(this.pc, this.name, this.pfmc, pNodeIArray);
    }

    public String getName() {
        return this.name;
    }

    public PostfixMathCommandI getPfmc() {
        return this.pfmc;
    }

    public int getNArgs() {
        return this.args.length;
    }

    public PNodeI getArg(int n) {
        return this.args[n];
    }

    @Override
    public void convertToPolyArray(String string, Map<Integer, PNodeI> map) throws ParseException {
        super.addToMap(map, 0, this);
    }

    @Override
    public PNodeI negate() throws ParseException {
        return Monomial.valueOf(this.pc, this.pc.minusOneConstant, this);
    }
}

