/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.polynomials;

import com.singularsys.extensions.polynomials.AbstractPNode;
import com.singularsys.extensions.polynomials.Monomial;
import com.singularsys.extensions.polynomials.PNodeI;
import com.singularsys.extensions.polynomials.PolynomialCreator;
import com.singularsys.jep.Operator;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.Node;
import java.util.Map;

public class POperator
extends AbstractPNode {
    Operator op;
    PNodeI[] args;

    public POperator(PolynomialCreator polynomialCreator, Operator operator, PNodeI[] pNodeIArray) {
        super(polynomialCreator);
        this.op = operator;
        this.args = pNodeIArray;
    }

    @Override
    public boolean equalsPNode(PNodeI pNodeI) {
        if (!(pNodeI instanceof POperator)) {
            return false;
        }
        POperator pOperator = (POperator)pNodeI;
        if (!this.op.equals(pOperator)) {
            return false;
        }
        if (this.args.length != pOperator.args.length) {
            return false;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].equalsPNode(pOperator.args[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(POperator pOperator) {
        int n = this.op.getName().compareTo(this.op.getName());
        if (n != 0) {
            return n;
        }
        if (this.args.length < pOperator.args.length) {
            return -1;
        }
        if (this.args.length > pOperator.args.length) {
            return 1;
        }
        for (int i = 0; i < this.args.length; ++i) {
            n = this.args[i].compareTo(pOperator.args[i]);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    @Override
    public String toString() {
        if (this.args.length == 1) {
            if (this.op.isPrefix()) {
                return "(" + this.op.getSymbol() + this.args[0].toString() + ")";
            }
        } else if (this.args.length == 2) {
            return "((" + this.args[0].toString() + ")" + this.op.getSymbol() + "(" + this.args[1].toString() + "))";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.op.getSymbol() + "(");
        int n = 0;
        for (PNodeI pNodeI : this.args) {
            if (n++ > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(pNodeI);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public Node toNode() throws ParseException {
        Node[] nodeArray = new Node[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            nodeArray[i] = this.args[i].toNode();
        }
        ASTOpNode aSTOpNode = this.pc.getNodeFactory().buildOperatorNode(this.op, nodeArray);
        return aSTOpNode;
    }

    @Override
    public Node toCompactNode() throws ParseException {
        return this.toNode();
    }

    @Override
    public PNodeI expand() throws ParseException {
        PNodeI[] pNodeIArray = new PNodeI[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            pNodeIArray[i] = this.args[i].expand();
        }
        return new POperator(this.pc, this.op, pNodeIArray);
    }

    public String getName() {
        return this.op.getName();
    }

    public PostfixMathCommandI getPfmc() {
        return this.op.getPFMC();
    }

    public int getNArgs() {
        return this.args.length;
    }

    public PNodeI getArg(int n) {
        return this.args[n];
    }

    public Operator getOp() {
        return this.op;
    }

    @Override
    public void convertToPolyArray(String string, Map<Integer, PNodeI> map) throws ParseException {
        throw new ParseException("Cannot covert operators to arrays");
    }

    @Override
    public PNodeI negate() throws ParseException {
        return Monomial.valueOf(this.pc, this.pc.minusOneConstant, this);
    }
}

