/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.rewrite;

import com.singularsys.extensions.rewrite.RewriteRuleI;
import com.singularsys.extensions.xjep.ExpressionCleaner;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepException;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.walkers.DoNothingVisitor;
import java.util.ArrayList;
import java.util.List;

public class RewriteVisitor
extends DoNothingVisitor {
    private static final long serialVersionUID = 1L;
    private final List<RewriteRuleI> rules = new ArrayList<RewriteRuleI>();
    private boolean simp = false;
    ExpressionCleaner cleaner;
    private static boolean DEBUG = false;

    public RewriteVisitor() {
    }

    public RewriteVisitor(Jep jep) {
        this.init(jep);
    }

    @Override
    public void init(Jep jep) {
        this.jep = jep;
        this.nf = this.jep.getNodeFactory();
        this.ot = this.jep.getOperatorTable();
        this.cleaner = (ExpressionCleaner)this.jep.getAdditionalComponent(ExpressionCleaner.class);
        if (this.rules != null) {
            for (RewriteRuleI rewriteRuleI : this.rules) {
                rewriteRuleI.init(this.jep);
            }
        }
    }

    public Node rewrite(Node node, boolean bl) throws ParseException {
        Node node2;
        this.simp = bl;
        if (this.rules.size() == 0) {
            return node;
        }
        if (node == null) {
            throw new IllegalArgumentException("topNode parameter is null");
        }
        try {
            node2 = (Node)node.jjtAccept(this, null);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (JepException jepException) {
            throw new ParseException(jepException);
        }
        return node2;
    }

    @Override
    public Object visit(ASTOpNode aSTOpNode, Object object) throws JepException {
        return this.visitFun(aSTOpNode, object);
    }

    @Override
    public Object visit(ASTFunNode aSTFunNode, Object object) throws JepException {
        return this.visitFun(aSTFunNode, object);
    }

    public Object visitFun(ASTFunNode aSTFunNode, Object object) throws JepException {
        Node[] nodeArray = this.visitChildren(aSTFunNode, object);
        boolean bl = this.childrenHaveChanged(aSTFunNode, nodeArray);
        if (bl) {
            aSTFunNode = (ASTFunNode)this.copyChildrenIfNeeded(aSTFunNode, nodeArray);
            if (this.simp) {
                Node node = this.cleaner.clean(aSTFunNode);
                if (!(node instanceof ASTFunNode)) {
                    return node;
                }
                aSTFunNode = (ASTFunNode)node;
            }
        }
        for (RewriteRuleI rewriteRuleI : this.rules) {
            Node node;
            if (!rewriteRuleI.test(aSTFunNode, nodeArray)) continue;
            if (DEBUG) {
                System.out.println("Rewriting\t" + this.jep.toString(aSTFunNode));
            }
            if (aSTFunNode == (node = rewriteRuleI.apply(aSTFunNode, nodeArray))) {
                return aSTFunNode;
            }
            if (DEBUG) {
                System.out.println("To\t\t" + this.jep.toString(node));
            }
            if (this.simp) {
                node = this.cleaner.clean(node);
                if (DEBUG) {
                    System.out.println("Simplified\t" + this.jep.toString(node));
                }
            }
            Node node2 = (Node)node.jjtAccept(this, object);
            if (DEBUG) {
                System.out.println("Accepted\t" + this.jep.toString(node2));
            }
            return node2;
        }
        return aSTFunNode;
    }

    public boolean add(RewriteRuleI rewriteRuleI) {
        return this.rules.add(rewriteRuleI);
    }

    public List<RewriteRuleI> getRules() {
        return this.rules;
    }
}

