/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.statistical;

import com.singularsys.extensions.field.FieldI;
import com.singularsys.extensions.matrix.MatrixFactoryI;
import com.singularsys.extensions.statistical.ArgumentExpander;
import com.singularsys.extensions.statistical.FieldComparator;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.NaryFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class SortElements
extends NaryFunction
implements JepComponent {
    private static final long serialVersionUID = 330L;
    FieldI fm;
    FieldComparator fc;
    boolean increasing = true;
    PostfixMathCommandI listFun;
    MatrixFactoryI mfac;

    public SortElements(boolean bl, FieldI fieldI) {
        this.fm = fieldI;
        this.fc = new FieldComparator(fieldI, bl);
        this.increasing = bl;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n > 0;
    }

    @Override
    public Object eval(Object[] objectArray) throws EvaluationException {
        Stack<Object> stack;
        Processor processor = new Processor();
        processor.doArg(objectArray);
        Collections.sort(processor.data);
        Object[] objectArray2 = new Object[processor.neles];
        int n = 0;
        for (SortElement sortElement : processor.data) {
            objectArray2[n] = sortElement.data;
            ++n;
        }
        if (this.mfac != null) {
            stack = this.mfac.newVector(objectArray2);
            return stack;
        }
        if (this.listFun instanceof NaryFunction) {
            return ((NaryFunction)this.listFun).eval(objectArray2);
        }
        if (this.listFun != null) {
            stack = new Stack<Object>();
            stack.addAll(Arrays.asList(objectArray2));
            this.listFun.setCurNumberOfParameters(objectArray2.length);
            this.listFun.run(stack);
            return stack.pop();
        }
        return objectArray2;
    }

    @Override
    public void init(Jep jep) {
        this.listFun = jep.getOperatorTable().getList().getPFMC();
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return new SortElements(this.increasing, this.fm);
    }

    class Processor
    extends ArgumentExpander {
        int neles = 0;
        List<SortElement> data = new ArrayList<SortElement>();
        List<SortElement> orig = new ArrayList<SortElement>();

        Processor() {
        }

        @Override
        protected void doSingleArg(Object object) throws EvaluationException {
            SortElement sortElement = new SortElement(object, this.neles, -1);
            this.orig.add(sortElement);
            this.data.add(sortElement);
            ++this.neles;
        }
    }

    class SortElement
    implements Comparable<SortElement> {
        Object data;
        int orig;
        Object pos;

        public SortElement(Object object, int n, Object object2) {
            this.data = object;
            this.orig = n;
            this.pos = object2;
        }

        @Override
        public int compareTo(SortElement sortElement) {
            return SortElements.this.fc.compare(this.data, sortElement.data);
        }

        public String toString() {
            return "(" + this.data + "," + this.orig + "," + this.pos + ")";
        }
    }
}

