/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.statistical.distributions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.Binomial;
import com.singularsys.jep.functions.NaryFunction;
import com.singularsys.jep.functions.Power;

public class BinomialDist
extends NaryFunction {
    private static final long serialVersionUID = 350L;

    public BinomialDist() {
        super(3);
    }

    public BinomialDist(boolean bl) {
        super(bl ? -1 : 3);
    }

    @Override
    public Object eval(Object[] objectArray) throws EvaluationException {
        int n = this.asInt(0, objectArray[0]);
        int n2 = this.asInt(1, objectArray[1]);
        double d = this.asDouble(2, objectArray[2]);
        if (objectArray.length == 4 && this.asInt(3, objectArray[3]) != 0) {
            double d2 = BinomialDist.cdf(n, n2, d);
            return d2;
        }
        double d3 = BinomialDist.bidist(n, n2, d);
        return d3;
    }

    public static double bidist(int n, int n2, double d) {
        int n3 = Binomial.binom(n2, n);
        double d2 = 1.0 - d;
        double d3 = Power.power(d, n);
        double d4 = Power.power(d2, n2 - n);
        return (double)n3 * d3 * d4;
    }

    public static double cdf(int n, int n2, double d) {
        double d2 = 0.0;
        for (int i = 0; i <= n; ++i) {
            d2 += BinomialDist.bidist(i, n2, d);
        }
        return d2;
    }
}

