/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.statistical.distributions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.NaryFunction;

public class NormalInverse
extends NaryFunction {
    private static final long serialVersionUID = 305L;
    static long[] num = new long[]{1L, 1L, 7L, 127L, 4369L, 34807L, 20036983L, 2280356863L, 49020204823L, 65967241200001L, 15773461423793767L, 655889589032992201L};
    static long[] den = new long[]{1L, 1L, 6L, 90L, 2520L, 16200L, 7484400L, 681080400L, 11675664000L, 12504636144000L, 2375880867360000L, 78404068622880000L};

    @Override
    public Object eval(Object[] objectArray) throws EvaluationException {
        double d = this.asDouble(0, objectArray[0]);
        double d2 = this.asDouble(1, objectArray[1]);
        double d3 = this.asDouble(2, objectArray[2]);
        double d4 = NormalInverse.icdf(d, d2, d3);
        return d4;
    }

    public static double ierf(double d) {
        double d2 = -Math.log((1.0 - d) * (1.0 + d));
        System.out.println(d2);
        if (d2 < 0.5) {
            return NormalInverse.ierfCen(d);
        }
        if (d2 < 5.0) {
            double d3 = 2.810226362726098E-8;
            d3 = 3.432739390518691E-7 + d3 * (d2 -= 2.5);
            d3 = -3.523387704262859E-6 + d3 * d2;
            d3 = -4.391506536194356E-6 + d3 * d2;
            d3 = 2.1858086984138936E-4 + d3 * d2;
            d3 = -0.001253725029528141 + d3 * d2;
            d3 = -0.004177681636065245 + d3 * d2;
            d3 = 0.24664072692394257 + d3 * d2;
            d3 = 1.5014094114303589 + d3 * d2;
            return d3 * d;
        }
        d2 = Math.sqrt(d2) - 3.0;
        double d4 = -2.002142573473975E-4;
        d4 = 1.009505576803349E-4 + d4 * d2;
        d4 = 0.0013493432197719812 + d4 * d2;
        d4 = -0.003673428436741233 + d4 * d2;
        d4 = 0.005739507731050253 + d4 * d2;
        d4 = -0.007622461300343275 + d4 * d2;
        d4 = 0.00943887047469616 + d4 * d2;
        d4 = (double)1.001674f + d4 * d2;
        d4 = 2.832976818084717 + d4 * d2;
        return d4 * d;
    }

    public static double ierfCen(double d) {
        double d2 = 0.0;
        double d3 = d * Math.sqrt(Math.PI) / 2.0;
        double d4 = d * d * Math.PI / 4.0;
        double d5 = d3;
        for (int i = 0; i < num.length; ++i) {
            double d6 = d5 * (double)num[i] / ((double)den[i] * (2.0 * (double)i + 1.0));
            d2 += d6;
            d5 *= d4;
        }
        return d2;
    }

    public static double iscdf(double d) {
        double d2 = d * 2.0 - 1.0;
        double d3 = NormalInverse.ierf(d2);
        double d4 = Math.sqrt(2.0) * d3;
        return d4;
    }

    public static double icdf(double d, double d2, double d3) {
        double d4 = NormalInverse.iscdf(d);
        double d5 = d4 * d3 + d2;
        return d5;
    }
}

