/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.xjep;

import com.singularsys.extensions.xjep.CommandVisitorI;
import com.singularsys.extensions.xjep.SymbolicLValueI;
import com.singularsys.extensions.xjep.TreeUtils;
import com.singularsys.extensions.xjep.XJep;
import com.singularsys.extensions.xjep.XVariable;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.functions.Assign;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import java.util.Stack;

public class XAssign
extends PostfixMathCommand
implements CallbackEvaluationI,
CommandVisitorI,
JepComponent {
    private static final long serialVersionUID = 1100L;
    CallbackEvaluationI root;
    XJep xjep;
    boolean useEqn = true;

    public XAssign() {
        this(new Assign());
    }

    public XAssign(boolean bl) {
        this();
        this.useEqn = bl;
    }

    public XAssign(CallbackEvaluationI callbackEvaluationI) {
        super(2);
        this.root = callbackEvaluationI;
    }

    @Override
    public Node process(Node node, Node[] nodeArray) throws ParseException {
        if (node.jjtGetNumChildren() != 2) {
            throw new ParseException("Assignment opperator must have 2 operators.");
        }
        Node node2 = nodeArray[0];
        Node node3 = nodeArray[1];
        if (node2 instanceof ASTVarNode) {
            ASTVarNode aSTVarNode = (ASTVarNode)node2;
            XVariable xVariable = (XVariable)aSTVarNode.getVar();
            if (this.useEqn) {
                xVariable.setEquation(this.xjep.deepCopy(node3));
            } else {
                xVariable.setEquation(null);
            }
            TreeUtils.setChildrenIfNeeded(node, nodeArray);
            return node;
        }
        if (node2 instanceof ASTFunNode && ((ASTFunNode)node2).getPFMC() instanceof SymbolicLValueI) {
            SymbolicLValueI symbolicLValueI = (SymbolicLValueI)((Object)((ASTFunNode)node2).getPFMC());
            if (this.useEqn) {
                symbolicLValueI.setEqn(this.xjep, node2, this.xjep.deepCopy(node3));
            }
            TreeUtils.setChildrenIfNeeded(node, nodeArray);
            return node;
        }
        throw new ParseException("Assignment should have a variable for the lhs.");
    }

    @Override
    public Object evaluate(Node node, Evaluator evaluator) throws EvaluationException {
        return this.root.evaluate(node, evaluator);
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        throw new EvaluationException("Assign: run methods should not have been called");
    }

    public boolean isUseEquation() {
        return this.useEqn;
    }

    @Override
    public void init(Jep jep) {
        this.xjep = (XJep)jep;
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return new XAssign();
    }
}

