/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.xjep;

import com.singularsys.extensions.xjep.XVariable;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Variable;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.standard.FastEvaluator;

public class XEvaluator
extends FastEvaluator {
    private static final long serialVersionUID = 1100L;
    boolean force;

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    @Override
    public Object visitVar(Node node) throws EvaluationException {
        Variable variable = node.getVar();
        if (variable == null) {
            String string = "Could not evaluate " + node.getName() + ": ";
            throw new EvaluationException(string + " variable not set");
        }
        Object object = null;
        if (variable instanceof XVariable && ((XVariable)variable).getEquation() != null && (this.force || !variable.hasValidValue())) {
            Node node2 = ((XVariable)variable).getEquation();
            if (node2 == null) {
                throw new EvaluationException("Cannot find value of " + variable.getName() + " no equation.");
            }
            object = this.nodeAccept(node2);
            if (this.isTrapNullValues() && object == null) {
                String string = "Could not evaluate " + variable.getName() + ": null value";
                throw new EvaluationException(string);
            }
        } else {
            if (variable.hasValidValue()) {
                object = variable.getValue();
                if (this.isTrapNullValues() && object == null) {
                    String string = "Could not evaluate " + variable.getName() + ": null value";
                    throw new EvaluationException(string);
                }
                return object;
            }
            if (variable instanceof XVariable) {
                throw new EvaluationException("Cannot find value of " + variable.getName() + ": no equation and no value set.");
            }
            throw new EvaluationException("Could not evaluate " + variable.getName() + ": value not set");
        }
        variable.setValue(object);
        return object;
    }
}

