/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.Operator;
import com.singularsys.jep.OperatorTable2;
import com.singularsys.jep.OperatorTableI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EmptyOperatorTable
implements OperatorTableI {
    private static final long serialVersionUID = 340L;
    Map<OperatorKey, Operator> operators = new HashMap<OperatorKey, Operator>();

    @Override
    public Operator getAdd() {
        return null;
    }

    @Override
    public Operator getAnd() {
        return null;
    }

    @Override
    public Operator getAssign() {
        return null;
    }

    @Override
    public Operator getCross() {
        return null;
    }

    @Override
    public Operator getDivide() {
        return null;
    }

    @Override
    public Operator getDot() {
        return null;
    }

    @Override
    public Operator getEQ() {
        return null;
    }

    @Override
    public Operator getEle() {
        return null;
    }

    @Override
    public Operator getGE() {
        return null;
    }

    @Override
    public Operator getGT() {
        return null;
    }

    @Override
    public Operator getLE() {
        return null;
    }

    @Override
    public Operator getLT() {
        return null;
    }

    @Override
    public Operator getList() {
        return null;
    }

    @Override
    public Operator getMod() {
        return null;
    }

    @Override
    public Operator getMultiply() {
        return null;
    }

    @Override
    public Operator getNE() {
        return null;
    }

    @Override
    public Operator getNop() {
        return null;
    }

    @Override
    public Operator getNot() {
        return null;
    }

    @Override
    public Operator getOr() {
        return null;
    }

    @Override
    public Operator getPower() {
        return null;
    }

    @Override
    public Operator getRange() {
        return null;
    }

    @Override
    public Operator getSubtract() {
        return null;
    }

    @Override
    public Operator getUDivide() {
        return null;
    }

    @Override
    public Operator getUMinus() {
        return null;
    }

    @Override
    public Operator getUPlus() {
        return null;
    }

    @Override
    public void init(Jep jep) {
        for (Operator operator : this.operators.values()) {
            if (!(operator.getPFMC() instanceof JepComponent)) continue;
            ((JepComponent)((Object)operator.getPFMC())).init(jep);
        }
    }

    public int getNumOps() {
        return this.operators.size();
    }

    public Operator addOperator(OperatorKey operatorKey, Operator operator) {
        this.operators.put(operatorKey, operator);
        return operator;
    }

    public Operator addOperator(OperatorKey operatorKey, Operator operator, Operator operator2) {
        this.addOperator(operatorKey, operator);
        operator.setPrecedence(operator2.getPrecedence());
        return operator;
    }

    public Operator insertOperator(OperatorKey operatorKey, Operator operator, Operator operator2) {
        int n = operator2.getPrecedence();
        for (Operator operator3 : this.operators.values()) {
            if (operator3.getPrecedence() < n) continue;
            operator3.setPrecedence(operator3.getPrecedence() + 1);
        }
        operator.setPrecedence(n);
        this.addOperator(operatorKey, operator);
        return operator;
    }

    public Operator appendOperator(OperatorKey operatorKey, Operator operator, Operator operator2) {
        this.addOperator(operatorKey, operator);
        int n = operator2.getPrecedence() + 1;
        for (Operator operator3 : this.operators.values()) {
            if (operator3.getPrecedence() < n) continue;
            operator3.setPrecedence(operator3.getPrecedence() + 1);
        }
        operator.setPrecedence(n);
        return operator;
    }

    public OperatorKey getKey(Operator operator) {
        for (Map.Entry<OperatorKey, Operator> entry : this.operators.entrySet()) {
            Operator operator2 = entry.getValue();
            if (!operator2.equals(operator)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void removeOperator(Operator operator) {
        OperatorKey operatorKey = this.getKey(operator);
        if (operatorKey != null) {
            this.removeOperator(operatorKey);
        }
    }

    public void removeOperator(OperatorKey operatorKey) {
        this.operators.remove(operatorKey);
    }

    public void replaceOperator(Operator operator, Operator operator2) {
        OperatorKey operatorKey = this.getKey(operator);
        operator2.setPrecedence(operator.getPrecedence());
        if (operatorKey != null) {
            this.addOperator(operatorKey, operator2);
        }
    }

    public void replaceOperator(OperatorKey operatorKey, Operator operator) {
        Operator operator2 = this.getOperator(operatorKey);
        if (operator2 != null) {
            operator.setPrecedence(operator2.getPrecedence());
        }
        this.addOperator(operatorKey, operator);
    }

    public Operator getOperator(OperatorKey operatorKey) {
        return this.operators.get(operatorKey);
    }

    @Override
    public List<Operator> getOperatorsBySymbol(String string) {
        ArrayList<Operator> arrayList = new ArrayList<Operator>();
        for (Operator operator : this.operators.values()) {
            if (!operator.getSymbol().equals(string)) continue;
            arrayList.add(operator);
        }
        return arrayList;
    }

    @Override
    public Operator getOperatorsByName(String string) {
        for (Operator operator : this.operators.values()) {
            if (!operator.getName().equals(string)) continue;
            return operator;
        }
        return null;
    }

    @Override
    public Collection<Operator> getOperators() {
        return this.operators.values();
    }

    public Set<Map.Entry<OperatorKey, Operator>> entrySet() {
        return this.operators.entrySet();
    }

    public Set<OperatorKey> keySet() {
        return this.operators.keySet();
    }

    public final boolean setPrecedenceTable(OperatorKey[][] operatorKeyArray) {
        boolean bl = true;
        for (int i = 0; i < operatorKeyArray.length; ++i) {
            for (int j = 0; j < operatorKeyArray[i].length; ++j) {
                Operator operator = this.getOperator(operatorKeyArray[i][j]);
                if (operator != null) {
                    operator.setPrecedence(i);
                    continue;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected boolean setInverseOp(OperatorKey operatorKey, OperatorKey operatorKey2) {
        Operator operator = this.getOperator(operatorKey);
        Operator operator2 = this.getOperator(operatorKey2);
        if (operator == null || operator2 == null) {
            return false;
        }
        operator.setInverseOp(operator2);
        return true;
    }

    protected boolean setBinaryInverseOp(OperatorKey operatorKey, OperatorKey operatorKey2) {
        Operator operator = this.getOperator(operatorKey);
        Operator operator2 = this.getOperator(operatorKey2);
        if (operator == null || operator2 == null) {
            return false;
        }
        operator.setBinaryInverseOp(operator2);
        return true;
    }

    protected boolean setRootOp(OperatorKey operatorKey, OperatorKey operatorKey2) {
        Operator operator = this.getOperator(operatorKey);
        Operator operator2 = this.getOperator(operatorKey2);
        if (operator == null || operator2 == null) {
            return false;
        }
        operator.setRootOp(operator2);
        return true;
    }

    protected boolean setDistributiveOver(OperatorKey operatorKey, OperatorKey operatorKey2) {
        Operator operator = this.getOperator(operatorKey);
        Operator operator2 = this.getOperator(operatorKey2);
        if (operator == null || operator2 == null) {
            return false;
        }
        operator.setDistributiveOver(operator2);
        return true;
    }

    protected void setGroupOperatorRelations(Operator operator, Operator operator2, Operator operator3) {
        if (operator != null) {
            operator.setInverseOp(operator2);
            operator.setBinaryInverseOp(operator3);
        }
        if (operator3 != null) {
            operator3.setRootOp(operator);
            operator3.setInverseOp(operator2);
        }
        if (operator2 != null) {
            operator2.setRootOp(operator);
            operator2.setBinaryInverseOp(operator3);
        }
    }

    protected void setGroupOperatorRelations(OperatorKey operatorKey, OperatorKey operatorKey2, OperatorKey operatorKey3) {
        this.setGroupOperatorRelations(this.getOperator(operatorKey), this.getOperator(operatorKey2), this.getOperator(operatorKey3));
    }

    protected void setStandardOperatorRelations() {
        this.setGroupOperatorRelations(OperatorTable2.BasicOperators.ADD, OperatorTable2.BasicOperators.NEG, OperatorTable2.BasicOperators.SUB);
        this.setGroupOperatorRelations(OperatorTable2.BasicOperators.MUL, OperatorTable2.PsudoOperators.RECIP, OperatorTable2.BasicOperators.DIV);
        this.setDistributiveOver(OperatorTable2.BasicOperators.NEG, OperatorTable2.BasicOperators.ADD);
        this.setDistributiveOver(OperatorTable2.BasicOperators.NEG, OperatorTable2.BasicOperators.SUB);
        this.setDistributiveOver(OperatorTable2.BasicOperators.MUL, OperatorTable2.BasicOperators.ADD);
        this.setDistributiveOver(OperatorTable2.BasicOperators.MUL, OperatorTable2.BasicOperators.SUB);
        this.setDistributiveOver(OperatorTable2.BasicOperators.MUL, OperatorTable2.BasicOperators.NEG);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (Operator operator : this.operators.values()) {
            int n3 = operator.getPrecedence();
            if (n3 < n) {
                n = n3;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        int n4 = 0;
        stringBuilder.append(JepMessages.getString("standard.EmptyOperatorTable.ListStart"));
        for (int i = n; i <= n2; ++i) {
            for (Operator operator : this.operators.values()) {
                if (operator.getPrecedence() != i) continue;
                if (n4++ > 0) {
                    stringBuilder.append(JepMessages.getString("standard.EmptyOperatorTable.ListSeparator"));
                }
                stringBuilder.append(operator.toFullString());
            }
        }
        stringBuilder.append(JepMessages.getString("standard.EmptyOperatorTable.ListEnd"));
        return stringBuilder.toString();
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return this;
    }

    public static interface OperatorKey {
    }
}

