/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.Operator;
import com.singularsys.jep.OperatorTableI;
import com.singularsys.jep.ParserVisitor;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.standard.Complex;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.HashMap;

public class PrintVisitor
implements ParserVisitor,
JepComponent {
    private static final long serialVersionUID = 330L;
    protected String LBracket = "(";
    protected String RBracket = ")";
    protected String FunLBracket = "(";
    protected String FunRBracket = ")";
    protected String FunctionArgSep = ",";
    public static final int FULL_BRACKET = 1;
    public static final int COMPLEX_I = 2;
    private int maxLen = -1;
    protected transient StringBuffer sb;
    protected int mode = 0;
    protected HashMap<Operator, PrintRulesI> specialRules = new HashMap();
    protected HashMap<String, PrintRulesI> specialFunRules = new HashMap();
    protected HashMap<String, String> specialVarName = new HashMap();
    protected NumberFormat format;
    protected transient FieldPosition fp = new FieldPosition(1);
    protected OperatorTableI ot;
    public static final NullPrintVisitor NULL_PRINT_VISITOR = new NullPrintVisitor();

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.fp = new FieldPosition(1);
    }

    @Override
    public void init(Jep jep) {
        this.ot = jep.getOperatorTable();
        Operator operator = jep.getOperatorTable().getList();
        Operator operator2 = jep.getOperatorTable().getEle();
        if (operator != null && !this.specialRules.containsKey(operator)) {
            this.specialRules.put(operator, new StdListPrintRule());
        }
        if (operator2 != null && !this.specialRules.containsKey(operator2)) {
            this.specialRules.put(operator2, new StdElePrintRule());
        }
    }

    public void print(Node node, PrintStream printStream) {
        if (node == null) {
            printStream.print("null");
            return;
        }
        this.sb = new StringBuffer();
        try {
            node.jjtAccept(this, null);
        }
        catch (JepException jepException) {
            // empty catch block
        }
        this.printWrap(this.sb, printStream);
    }

    public void printWrap(StringBuffer stringBuffer, PrintStream printStream) {
        if (this.maxLen != -1) {
            while (true) {
                if (stringBuffer.length() < this.maxLen) {
                    printStream.print(stringBuffer);
                    return;
                }
                int n = this.maxLen - 2;
                for (int i = this.maxLen - 2; i >= 0; --i) {
                    char c = stringBuffer.charAt(i);
                    if (Character.isLetterOrDigit(c) || c == '_' || c == '.') continue;
                    n = i;
                    break;
                }
                printStream.println(stringBuffer.substring(0, n + 1));
                stringBuffer.delete(0, n + 1);
            }
        }
        printStream.print(stringBuffer);
    }

    public void print(Node node) {
        this.print(node, System.out);
    }

    public void println(Node node, PrintStream printStream) {
        this.print(node, printStream);
        printStream.println();
    }

    public void println(Node node) {
        this.println(node, System.out);
    }

    public String toString(Node node) {
        if (node == null) {
            return null;
        }
        this.sb = new StringBuffer();
        try {
            node.jjtAccept(this, null);
        }
        catch (JepException jepException) {
            // empty catch block
        }
        return this.sb.toString();
    }

    public void append(String string) {
        this.sb.append(string);
    }

    public void addSpecialRule(Operator operator, PrintRulesI printRulesI) {
        this.specialRules.put(operator, printRulesI);
    }

    public void addSpecialRule(String string, PrintRulesI printRulesI) {
        this.specialFunRules.put(string, printRulesI);
    }

    public String addSpecialVarName(String string, String string2) {
        return this.specialVarName.put(string, string2);
    }

    public void printNoBrackets(Node node) throws JepException {
        node.jjtAccept(this, null);
    }

    public void printBrackets(Node node) throws JepException {
        this.sb.append(this.LBracket);
        this.printNoBrackets(node);
        this.sb.append(this.RBracket);
    }

    private Object visitUnary(ASTOpNode aSTOpNode, Object object) throws JepException {
        Node node = aSTOpNode.jjtGetChild(0);
        String string = aSTOpNode.getOperator().getPrintSymbol();
        if (string == null) {
            string = aSTOpNode.getOperator().getSymbol();
        }
        if (aSTOpNode.getOperator().isPrefix()) {
            this.sb.append(string);
        }
        if (node instanceof ASTOpNode) {
            this.printBrackets(node);
        } else {
            this.printNoBrackets(node);
        }
        if (aSTOpNode.getOperator().isSuffix()) {
            this.sb.append(string);
        }
        return object;
    }

    protected boolean testLeft(Operator operator, Node node) {
        if ((this.mode & 1) != 0) {
            Object object;
            if (node instanceof ASTOpNode) {
                return true;
            }
            if (node instanceof ASTVarNode || node instanceof ASTFunNode) {
                return false;
            }
            return !(node instanceof ASTConstant) || !((object = node.getValue()) instanceof Number) || !(((Number)object).doubleValue() >= 0.0);
        }
        if (node instanceof ASTOpNode) {
            Operator operator2 = ((ASTOpNode)node).getOperator();
            if (operator == operator2) {
                if (operator.isLeftBinding() && operator.isAssociative()) {
                    return false;
                }
                return !operator.useBindingForPrint();
            }
            if (operator.getPrecedence() == operator2.getPrecedence()) {
                if (operator2.isLeftBinding() && operator2.isAssociative()) {
                    return false;
                }
                return !operator2.useBindingForPrint();
            }
            return operator.getPrecedence() <= operator2.getPrecedence();
        }
        return false;
    }

    protected boolean testMid(Operator operator, Node node) {
        if ((this.mode & 1) != 0) {
            Object object;
            if (node instanceof ASTOpNode) {
                return true;
            }
            if (node instanceof ASTVarNode || node instanceof ASTFunNode) {
                return false;
            }
            return !(node instanceof ASTConstant) || !((object = node.getValue()) instanceof Number) || !(((Number)object).doubleValue() >= 0.0);
        }
        if (node instanceof ASTOpNode) {
            Operator operator2 = ((ASTOpNode)node).getOperator();
            if (operator == operator2) {
                return false;
            }
            if (operator.getPrecedence() == operator2.getPrecedence()) {
                return false;
            }
            if (operator2.isUnary()) {
                return true;
            }
            return operator.getPrecedence() <= operator2.getPrecedence();
        }
        return false;
    }

    protected boolean testRight(Operator operator, Node node) {
        if ((this.mode & 1) != 0) {
            Object object;
            if (node instanceof ASTOpNode) {
                return true;
            }
            if (node instanceof ASTVarNode || node instanceof ASTFunNode) {
                return false;
            }
            return !(node instanceof ASTConstant) || !((object = node.getValue()) instanceof Number) || !(((Number)object).doubleValue() >= 0.0);
        }
        if (node instanceof ASTOpNode) {
            Operator operator2 = ((ASTOpNode)node).getOperator();
            if (operator == operator2) {
                return !operator.isRightBinding() && !operator.isAssociative();
            }
            if (operator.getPrecedence() == operator2.getPrecedence()) {
                return !operator.isLeftBinding() || !operator.isAssociative();
            }
            if (operator2.isUnary()) {
                return true;
            }
            return operator.getPrecedence() <= operator2.getPrecedence();
        }
        return false;
    }

    private Object visitNaryBinary(ASTFunNode aSTFunNode, Operator operator) throws JepException {
        int n = aSTFunNode.jjtGetNumChildren();
        String string = operator.getPrintSymbol();
        if (string == null) {
            string = operator.getSymbol();
        }
        for (int i = 0; i < n; ++i) {
            Node node;
            if (i > 0) {
                this.sb.append(string);
            }
            if (this.testMid(operator, node = aSTFunNode.jjtGetChild(i))) {
                this.printBrackets(node);
                continue;
            }
            this.printNoBrackets(node);
        }
        return null;
    }

    @Override
    public Object visit(ASTFunNode aSTFunNode, Object object) throws JepException {
        PrintRulesI printRulesI = this.specialFunRules.get(aSTFunNode.getName());
        if (printRulesI != null) {
            printRulesI.append(aSTFunNode, this);
            return null;
        }
        this.sb.append(aSTFunNode.getName() + this.FunLBracket);
        for (int i = 0; i < aSTFunNode.jjtGetNumChildren(); ++i) {
            if (i > 0) {
                this.sb.append(this.FunctionArgSep);
            }
            aSTFunNode.jjtGetChild(i).jjtAccept(this, null);
        }
        this.sb.append(this.FunRBracket);
        return null;
    }

    @Override
    public Object visit(ASTOpNode aSTOpNode, Object object) throws JepException {
        if (aSTOpNode instanceof PrintRulesI) {
            ((PrintRulesI)((Object)aSTOpNode)).append(aSTOpNode, this);
            return null;
        }
        if (aSTOpNode.getOperator() == null) {
            throw new JepException(JepMessages.getString("PrintVisitor.NullOperatorWhenPrinting_node"));
        }
        if (this.specialRules.containsKey(aSTOpNode.getOperator())) {
            this.specialRules.get(aSTOpNode.getOperator()).append(aSTOpNode, this);
            return null;
        }
        if (aSTOpNode.getOperator().isUnary()) {
            return this.visitUnary(aSTOpNode, object);
        }
        if (aSTOpNode.getOperator().isBinary()) {
            Operator operator = aSTOpNode.getOperator();
            if (aSTOpNode.jjtGetNumChildren() != 2) {
                return this.visitNaryBinary(aSTOpNode, operator);
            }
            Node node = aSTOpNode.jjtGetChild(0);
            Node node2 = aSTOpNode.jjtGetChild(1);
            if (this.testLeft(operator, node)) {
                this.printBrackets(node);
            } else {
                this.printNoBrackets(node);
            }
            String string = aSTOpNode.getOperator().getPrintSymbol();
            if (string == null) {
                string = aSTOpNode.getOperator().getSymbol();
            }
            this.sb.append(string);
            if (this.testRight(operator, node2)) {
                this.printBrackets(node2);
            } else {
                this.printNoBrackets(node2);
            }
        }
        return null;
    }

    @Override
    public Object visit(ASTVarNode aSTVarNode, Object object) throws JepException {
        String string = this.specialVarName.get(aSTVarNode.getName());
        if (string != null) {
            this.sb.append(string);
        } else {
            this.sb.append(aSTVarNode.getName());
        }
        return object;
    }

    @Override
    public Object visit(ASTConstant aSTConstant, Object object) throws JepException {
        Object object2 = aSTConstant.getValue();
        this.formatValue(object2, this.sb);
        return object;
    }

    public void formatValue(Object object, StringBuffer stringBuffer) {
        if (object instanceof String) {
            stringBuffer.append('\"');
            stringBuffer.append(object);
            stringBuffer.append('\"');
        } else if (this.format != null) {
            if (object instanceof Double) {
                if (Double.isFinite((Double)object)) {
                    this.format.format(object, stringBuffer, this.fp);
                } else {
                    stringBuffer.append(object);
                }
            } else if (object instanceof Float) {
                if (Float.isFinite(((Float)object).floatValue())) {
                    this.format.format(object, stringBuffer, this.fp);
                } else {
                    stringBuffer.append(object);
                }
            } else if (object instanceof BigDecimal) {
                this.format.format(object, stringBuffer, this.fp);
            } else if (object instanceof Complex) {
                if ((this.mode & 2) == 2) {
                    stringBuffer.append(((Complex)object).toString(this.format, true));
                } else {
                    stringBuffer.append(((Complex)object).toString(this.format));
                }
            } else {
                stringBuffer.append(object);
            }
        } else if (object instanceof Complex) {
            stringBuffer.append(((Complex)object).toString((this.mode & 2) == 2, true));
        } else {
            stringBuffer.append(object);
        }
    }

    public String formatValue(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        this.formatValue(object, stringBuffer);
        return stringBuffer.toString();
    }

    public int getMode() {
        return this.mode;
    }

    public boolean getMode(int n) {
        return (this.mode & n) != 0;
    }

    public void setMode(int n, boolean bl) {
        this.mode |= n;
        if (!bl) {
            this.mode ^= n;
        }
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.format = numberFormat;
    }

    public void setMaxLen(int n) {
        this.maxLen = n;
    }

    public int getMaxLen() {
        return this.maxLen;
    }

    @Override
    public JepComponent getLightWeightInstance() {
        PrintVisitor printVisitor = new PrintVisitor();
        printVisitor.format = this.format;
        printVisitor.maxLen = this.maxLen;
        printVisitor.mode = this.mode;
        return printVisitor;
    }

    public String getLBracket() {
        return this.LBracket;
    }

    public void setLBracket(String string) {
        this.LBracket = string;
    }

    public String getRBracket() {
        return this.RBracket;
    }

    public void setRBracket(String string) {
        this.RBracket = string;
    }

    public String getFunLBracket() {
        return this.FunLBracket;
    }

    public void setFunLBracket(String string) {
        this.FunLBracket = string;
    }

    public String getFunRBracket() {
        return this.FunRBracket;
    }

    public void setFunRBracket(String string) {
        this.FunRBracket = string;
    }

    public String getFunArgSep() {
        return this.FunctionArgSep;
    }

    public void setFunArgSep(String string) {
        this.FunctionArgSep = string;
    }

    private static class NullPrintVisitor
    extends PrintVisitor {
        private static final long serialVersionUID = 341L;

        public NullPrintVisitor() {
            this.format = null;
            this.specialRules = null;
            this.specialFunRules = null;
            this.specialVarName = null;
            this.FunctionArgSep = null;
            this.FunLBracket = null;
            this.FunRBracket = null;
            this.LBracket = null;
            this.RBracket = null;
            this.ot = null;
            this.fp = null;
        }

        @Override
        public void init(Jep jep) {
        }

        @Override
        public JepComponent getLightWeightInstance() {
            return this;
        }
    }

    public static final class StdElePrintRule
    implements PrintRulesI {
        private static final long serialVersionUID = 300L;

        @Override
        public void append(Node node, PrintVisitor printVisitor) throws JepException {
            node.jjtGetChild(0).jjtAccept(printVisitor, null);
            for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
                Node node2 = node.jjtGetChild(i);
                if (node2.getOperator() == printVisitor.ot.getList()) {
                    node.jjtGetChild(i).jjtAccept(printVisitor, null);
                    continue;
                }
                printVisitor.append("[");
                node.jjtGetChild(i).jjtAccept(printVisitor, null);
                printVisitor.append("]");
            }
        }
    }

    public static final class StdListPrintRule
    implements PrintRulesI {
        private static final long serialVersionUID = 300L;

        @Override
        public void append(Node node, PrintVisitor printVisitor) throws JepException {
            printVisitor.append("[");
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                if (i > 0) {
                    printVisitor.append(",");
                }
                node.jjtGetChild(i).jjtAccept(printVisitor, null);
            }
            printVisitor.append("]");
        }
    }

    public static interface PrintRulesI
    extends Serializable {
        public void append(Node var1, PrintVisitor var2) throws JepException;
    }
}

