/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.Add;
import com.singularsys.jep.functions.IllegalParameterException;
import java.math.BigDecimal;
import java.math.MathContext;

public class BigDecAdd
extends Add {
    private static final long serialVersionUID = 340L;
    private boolean allowStrings = false;
    MathContext mc;

    public BigDecAdd(MathContext mathContext) {
        this.mc = mathContext;
    }

    public void setMathContext(MathContext mathContext) {
        this.mc = mathContext;
    }

    public MathContext getMathContext() {
        return this.mc;
    }

    @Override
    public Object add(Object object, Object object2) throws EvaluationException {
        if (object instanceof BigDecimal) {
            if (object2 instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                BigDecimal bigDecimal3 = this.mc != null ? bigDecimal.add(bigDecimal2, this.mc) : bigDecimal.add(bigDecimal2);
                return bigDecimal3;
            }
            if (object2 instanceof Double) {
                return this.add(object, BigDecimal.valueOf((Double)object2));
            }
            if (object2 instanceof Integer) {
                return this.add(object, BigDecimal.valueOf(((Integer)object2).intValue()));
            }
            if (object2 instanceof Float) {
                return this.add(object, BigDecimal.valueOf(((Float)object2).floatValue()));
            }
            if (object2 instanceof Short) {
                return this.add(object, BigDecimal.valueOf(((Short)object2).shortValue()));
            }
            if (object2 instanceof Long) {
                return this.add(object, BigDecimal.valueOf((Long)object2));
            }
            throw new IllegalParameterException((PostfixMathCommandI)this, 1, BigDecimal.class, object2);
        }
        if (object instanceof Double) {
            return this.add(BigDecimal.valueOf((Double)object), object2);
        }
        if (object instanceof Integer) {
            return this.add(BigDecimal.valueOf(((Integer)object).intValue()), object2);
        }
        if (object instanceof Float) {
            return this.add(BigDecimal.valueOf(((Float)object).floatValue()), object2);
        }
        if (object instanceof Short) {
            return this.add(BigDecimal.valueOf(((Short)object).shortValue()), object2);
        }
        if (object instanceof Long) {
            return this.add(BigDecimal.valueOf((Long)object), object2);
        }
        if (this.allowStrings && object instanceof String && object2 instanceof String) {
            return ((String)object).concat((String)object2);
        }
        throw new IllegalParameterException((PostfixMathCommandI)this, 0, BigDecimal.class, object);
    }

    public boolean getAllowStrings() {
        return this.allowStrings;
    }

    public void setAllowStrings(boolean bl) {
        this.allowStrings = bl;
    }
}

