/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.Multiply;
import java.math.BigDecimal;
import java.math.MathContext;

public class BigDecMul
extends Multiply {
    private static final long serialVersionUID = 300L;
    MathContext mc;

    public BigDecMul(MathContext mathContext) {
        this.mc = mathContext;
    }

    @Override
    public Object mul(Object object, Object object2) throws EvaluationException {
        if (object instanceof BigDecimal) {
            if (object2 instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                BigDecimal bigDecimal3 = this.mc != null ? bigDecimal.multiply(bigDecimal2, this.mc) : bigDecimal.multiply(bigDecimal2);
                return bigDecimal3;
            }
            if (object2 instanceof Double) {
                return this.mul(object, (Object)BigDecimal.valueOf((Double)object2));
            }
            if (object2 instanceof Integer) {
                return this.mul(object, (Object)BigDecimal.valueOf(((Integer)object2).intValue()));
            }
            if (object2 instanceof Float) {
                return this.mul(object, (Object)BigDecimal.valueOf(((Float)object2).floatValue()));
            }
            if (object2 instanceof Short) {
                return this.mul(object, (Object)BigDecimal.valueOf(((Short)object2).shortValue()));
            }
            if (object2 instanceof Long) {
                return this.mul(object, (Object)BigDecimal.valueOf((Long)object2));
            }
            throw new IllegalParameterException((PostfixMathCommandI)this, 1, BigDecimal.class, object2);
        }
        if (object instanceof Double) {
            return this.mul((Object)BigDecimal.valueOf((Double)object), object2);
        }
        if (object instanceof Integer) {
            return this.mul((Object)BigDecimal.valueOf(((Integer)object).intValue()), object2);
        }
        if (object instanceof Float) {
            return this.mul((Object)BigDecimal.valueOf(((Float)object).floatValue()), object2);
        }
        if (object instanceof Short) {
            return this.mul((Object)BigDecimal.valueOf(((Short)object).shortValue()), object2);
        }
        if (object instanceof Long) {
            return this.mul((Object)BigDecimal.valueOf((Long)object), object2);
        }
        throw new IllegalParameterException((PostfixMathCommandI)this, 0, BigDecimal.class, object);
    }

    public MathContext getMathContext() {
        return this.mc;
    }

    public void setMathContext(MathContext mathContext) {
        this.mc = mathContext;
    }
}

