/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.Power;
import java.math.BigDecimal;
import java.math.MathContext;

public class BigDecPow
extends Power {
    private static final long serialVersionUID = 300L;
    MathContext mc;

    public BigDecPow(MathContext mathContext) {
        this.mc = mathContext;
        this.numberOfParameters = 2;
    }

    @Override
    public Object power(Object object, Object object2) throws EvaluationException {
        if (object instanceof BigDecimal) {
            if (object2 instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                BigDecimal bigDecimal3 = this.mc != null ? bigDecimal.pow(bigDecimal2.intValueExact(), this.mc) : bigDecimal.pow(bigDecimal2.intValueExact());
                return bigDecimal3;
            }
            if (object2 instanceof Double) {
                return this.power(object, (Object)BigDecimal.valueOf((Double)object2));
            }
            if (object2 instanceof Integer) {
                return this.power(object, (Object)BigDecimal.valueOf(((Integer)object2).intValue()));
            }
            if (object2 instanceof Float) {
                return this.power(object, (Object)BigDecimal.valueOf(((Float)object2).floatValue()));
            }
            if (object2 instanceof Short) {
                return this.power(object, (Object)BigDecimal.valueOf(((Short)object2).shortValue()));
            }
            if (object2 instanceof Long) {
                return this.power(object, (Object)BigDecimal.valueOf((Long)object2));
            }
            throw new IllegalParameterException((PostfixMathCommandI)this, 1, BigDecimal.class, object2);
        }
        if (object instanceof Double) {
            return this.power((Object)BigDecimal.valueOf((Double)object), object2);
        }
        if (object instanceof Integer) {
            return this.power((Object)BigDecimal.valueOf(((Integer)object).intValue()), object2);
        }
        if (object instanceof Float) {
            return this.power((Object)BigDecimal.valueOf(((Float)object).floatValue()), object2);
        }
        if (object instanceof Short) {
            return this.power((Object)BigDecimal.valueOf(((Short)object).shortValue()), object2);
        }
        if (object instanceof Long) {
            return this.power((Object)BigDecimal.valueOf((Long)object), object2);
        }
        throw new IllegalParameterException((PostfixMathCommandI)this, 0, BigDecimal.class, object);
    }

    public MathContext getMathContext() {
        return this.mc;
    }

    public void setMathContext(MathContext mathContext) {
        this.mc = mathContext;
    }
}

