/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.configurableparser;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.Parser;
import com.singularsys.jep.configurableparser.GrammarParser;
import com.singularsys.jep.configurableparser.GrammarParserFactory;
import com.singularsys.jep.configurableparser.ShuntingYard;
import com.singularsys.jep.configurableparser.TokenFilter;
import com.singularsys.jep.configurableparser.Tokenizer;
import com.singularsys.jep.configurableparser.TokenizerFactory;
import com.singularsys.jep.configurableparser.WhiteSpaceCommentFilter;
import com.singularsys.jep.configurableparser.matchers.ArrayAccessGrammarMatcher;
import com.singularsys.jep.configurableparser.matchers.CommentTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.FunctionGrammarMatcher;
import com.singularsys.jep.configurableparser.matchers.GrammarMatcher;
import com.singularsys.jep.configurableparser.matchers.IdentifierTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.ListGrammarMatcher;
import com.singularsys.jep.configurableparser.matchers.ListOrBracketGrammarMatcher;
import com.singularsys.jep.configurableparser.matchers.NumberTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.OperatorTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.RoundBracketGrammarMatcher;
import com.singularsys.jep.configurableparser.matchers.StringTokenMatcher2;
import com.singularsys.jep.configurableparser.matchers.SymbolTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.TerminatorTokenMatcher;
import com.singularsys.jep.configurableparser.matchers.TokenMatcher;
import com.singularsys.jep.configurableparser.matchers.WhiteSpaceTokenMatcher;
import com.singularsys.jep.configurableparser.tokens.SymbolToken;
import com.singularsys.jep.configurableparser.tokens.Token;
import com.singularsys.jep.parser.Node;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConfigurableParser
implements Parser {
    private static final long serialVersionUID = 300L;
    protected List<TokenMatcher> m = new ArrayList<TokenMatcher>();
    protected List<TokenFilter> filters = new ArrayList<TokenFilter>();
    protected List<GrammarMatcher> g = new ArrayList<GrammarMatcher>();
    protected transient Tokenizer tk = null;
    protected transient Jep jep = null;
    protected OperatorTokenMatcher otm = null;
    protected SymbolTokenMatcher stm = new SymbolTokenMatcher();
    protected GrammarParserFactory gpf;
    protected TokenizerFactory tf;

    public ConfigurableParser() {
        this.otm = new OperatorTokenMatcher();
        this.gpf = new ShuntingYard.ShuntingYardGrammarParserFactory();
        this.tf = new Tokenizer.StandardTokenizerFactory();
    }

    @Override
    public void init(Jep jep) {
        this.jep = jep;
        for (TokenMatcher object : this.m) {
            object.init(jep);
        }
        for (TokenFilter tokenFilter : this.filters) {
            tokenFilter.init(jep);
        }
        for (GrammarMatcher grammarMatcher : this.g) {
            grammarMatcher.init(jep);
        }
        for (JepComponent jepComponent : jep.getAdditionalComponents()) {
            if (jepComponent instanceof GrammarParserFactory) {
                this.setGrammarParserFactory((GrammarParserFactory)jepComponent);
            }
            if (!(jepComponent instanceof TokenizerFactory)) continue;
            this.setTokenizerFactory((TokenizerFactory)jepComponent);
        }
    }

    @Override
    public Node parse(Reader reader) throws ParseException {
        List<Token> list = this.scan(reader);
        if (list == null) {
            throw new ParseException(JepMessages.getString("configurableparser.ConfigurableParser.EmptyInput"));
        }
        Iterator<Token> iterator = this.filter(list);
        Node node = this.parse(iterator);
        if (node == null) {
            throw new ParseException(JepMessages.getString("configurableparser.ConfigurableParser.EmptyInput"));
        }
        return node;
    }

    @Override
    public void restart(Reader reader) {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.tk = this.tf.newInstance(this, bufferedReader);
    }

    @Override
    public Node continueParse() throws ParseException {
        Node node;
        Iterator<Token> iterator;
        List<Token> list;
        do {
            if ((list = this.scan()) != null) continue;
            return null;
        } while (list.size() == 0 || !(iterator = this.filter(list)).hasNext() || (node = this.parse(iterator)) == null);
        return node;
    }

    public List<Token> scan(Reader reader) throws ParseException {
        this.restart(reader);
        List<Token> list = this.tk.scan();
        return list;
    }

    public List<Token> scan() throws ParseException {
        List<Token> list = this.tk.scan();
        return list;
    }

    public Iterator<Token> filter(List<Token> list) throws ParseException {
        Iterator<Token> iterator = list.iterator();
        for (TokenFilter tokenFilter : this.filters) {
            iterator = tokenFilter.filter(iterator);
        }
        return iterator;
    }

    public Node parse(Iterator<Token> iterator) throws ParseException {
        GrammarParser grammarParser = this.gpf.newInstance(this);
        Node node = grammarParser.parse(iterator);
        return node;
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return null;
    }

    public TokenMatcher addTokenMatcher(TokenMatcher tokenMatcher) {
        this.m.add(tokenMatcher);
        return tokenMatcher;
    }

    public List<TokenMatcher> getTokenMatchers() {
        return this.m;
    }

    public GrammarMatcher addGrammarMatcher(GrammarMatcher grammarMatcher) {
        this.g.add(grammarMatcher);
        return grammarMatcher;
    }

    public List<GrammarMatcher> getGrammarMatchers() {
        return this.g;
    }

    public TokenMatcher addHashComments() {
        CommentTokenMatcher commentTokenMatcher = CommentTokenMatcher.hashCommentMatcher();
        this.m.add(commentTokenMatcher);
        return commentTokenMatcher;
    }

    public void addSlashComments() {
        this.m.add(CommentTokenMatcher.slashStarCommentMatcher());
        this.m.add(CommentTokenMatcher.multiLineSlashStarCommentMatcher());
        this.m.add(CommentTokenMatcher.slashSlashCommentMatcher());
    }

    public TokenMatcher addDoubleQuoteStrings() {
        StringTokenMatcher2 stringTokenMatcher2 = StringTokenMatcher2.doubleQuoteStringMatcher();
        this.m.add(stringTokenMatcher2);
        return stringTokenMatcher2;
    }

    public TokenMatcher addSingleQuoteStrings() {
        StringTokenMatcher2 stringTokenMatcher2 = StringTokenMatcher2.singleQuoteStringMatcher();
        this.m.add(stringTokenMatcher2);
        return stringTokenMatcher2;
    }

    public TokenMatcher addWhiteSpace() {
        WhiteSpaceTokenMatcher whiteSpaceTokenMatcher = WhiteSpaceTokenMatcher.defaultWhiteSpaceTokenMatcher();
        this.m.add(whiteSpaceTokenMatcher);
        return whiteSpaceTokenMatcher;
    }

    public TokenFilter addWhiteSpaceCommentFilter() {
        WhiteSpaceCommentFilter whiteSpaceCommentFilter = new WhiteSpaceCommentFilter();
        this.filters.add(whiteSpaceCommentFilter);
        return whiteSpaceCommentFilter;
    }

    public TokenMatcher addExponentNumbers() {
        NumberTokenMatcher numberTokenMatcher = NumberTokenMatcher.exponentNumberTokenMatcher();
        this.m.add(numberTokenMatcher);
        return numberTokenMatcher;
    }

    public TokenMatcher addSimpleNumbers() {
        NumberTokenMatcher numberTokenMatcher = NumberTokenMatcher.defaultNumberTokenMatcher();
        this.m.add(numberTokenMatcher);
        return numberTokenMatcher;
    }

    public TokenMatcher addOperatorTokenMatcher() {
        this.m.add(this.otm);
        return this.otm;
    }

    public TokenMatcher getOperatorTokenMatcher() {
        this.m.add(this.otm);
        return this.otm;
    }

    public TokenMatcher addSymbols(String ... stringArray) {
        this.m.add(this.stm);
        for (String string : stringArray) {
            SymbolToken symbolToken = new SymbolToken(string);
            this.stm.add(symbolToken);
        }
        return this.stm;
    }

    public SymbolTokenMatcher getSymbolTokenMatcher() {
        return this.stm;
    }

    public SymbolToken getSymbolToken(String string) {
        SymbolToken symbolToken = this.stm.getSymbolToken(string);
        return symbolToken;
    }

    public void setImplicitMultiplicationSymbols(String ... stringArray) {
        for (String string : stringArray) {
            SymbolToken symbolToken = this.getSymbolToken(string);
            symbolToken.setRhsImpMul(true);
        }
    }

    public TokenMatcher addIdentifiers() {
        IdentifierTokenMatcher identifierTokenMatcher = IdentifierTokenMatcher.basicIdentifierMatcher();
        this.m.add(identifierTokenMatcher);
        return identifierTokenMatcher;
    }

    public TokenMatcher addSemiColonTerminator() {
        TerminatorTokenMatcher terminatorTokenMatcher = TerminatorTokenMatcher.semiColonTerminatorMatcher();
        this.m.add(terminatorTokenMatcher);
        return terminatorTokenMatcher;
    }

    public GrammarMatcher addBracketMatcher(String string, String string2) {
        SymbolToken symbolToken = this.getSymbolToken(string);
        SymbolToken symbolToken2 = this.getSymbolToken(string2);
        RoundBracketGrammarMatcher roundBracketGrammarMatcher = new RoundBracketGrammarMatcher(symbolToken, symbolToken2);
        this.g.add(roundBracketGrammarMatcher);
        return roundBracketGrammarMatcher;
    }

    public GrammarMatcher addFunctionMatcher(String string, String string2, String string3) {
        SymbolToken symbolToken = this.getSymbolToken(string);
        SymbolToken symbolToken2 = this.getSymbolToken(string2);
        SymbolToken symbolToken3 = this.getSymbolToken(string3);
        FunctionGrammarMatcher functionGrammarMatcher = new FunctionGrammarMatcher(symbolToken, symbolToken2, symbolToken3);
        this.g.add(functionGrammarMatcher);
        return functionGrammarMatcher;
    }

    public GrammarMatcher addListMatcher(String string, String string2, String string3) {
        SymbolToken symbolToken = this.getSymbolToken(string);
        SymbolToken symbolToken2 = this.getSymbolToken(string2);
        SymbolToken symbolToken3 = this.getSymbolToken(string3);
        ListGrammarMatcher listGrammarMatcher = new ListGrammarMatcher(symbolToken, symbolToken2, symbolToken3);
        this.g.add(listGrammarMatcher);
        return listGrammarMatcher;
    }

    public GrammarMatcher addArrayAccessMatcher(String string, String string2) {
        SymbolToken symbolToken = this.getSymbolToken(string);
        SymbolToken symbolToken2 = this.getSymbolToken(string2);
        ArrayAccessGrammarMatcher arrayAccessGrammarMatcher = new ArrayAccessGrammarMatcher(symbolToken, symbolToken2);
        this.g.add(arrayAccessGrammarMatcher);
        return arrayAccessGrammarMatcher;
    }

    public GrammarMatcher addListOrBracketMatcher(String string, String string2, String string3) {
        SymbolToken symbolToken = this.getSymbolToken(string);
        SymbolToken symbolToken2 = this.getSymbolToken(string2);
        SymbolToken symbolToken3 = this.getSymbolToken(string3);
        ListOrBracketGrammarMatcher listOrBracketGrammarMatcher = new ListOrBracketGrammarMatcher(symbolToken, symbolToken2, symbolToken3);
        this.g.add(listOrBracketGrammarMatcher);
        return listOrBracketGrammarMatcher;
    }

    public Jep getJep() {
        return this.jep;
    }

    public TokenizerFactory getTokenizerFactory() {
        return this.tf;
    }

    public void setTokenizerFactory(TokenizerFactory tokenizerFactory) {
        this.tf = tokenizerFactory;
    }

    public TokenFilter addTokenFilter(TokenFilter tokenFilter) {
        this.filters.add(tokenFilter);
        return tokenFilter;
    }

    public List<TokenFilter> getTokenFilters() {
        return this.filters;
    }

    public GrammarParserFactory getGrammarParserFactory() {
        return this.gpf;
    }

    public void setGrammarParserFactory(GrammarParserFactory grammarParserFactory) {
        this.gpf = grammarParserFactory;
    }
}

