/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.configurableparser;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.configurableparser.ConfigurableParser;
import com.singularsys.jep.configurableparser.TokenizerFactory;
import com.singularsys.jep.configurableparser.matchers.TokenMatcher;
import com.singularsys.jep.configurableparser.tokens.MultiLineToken;
import com.singularsys.jep.configurableparser.tokens.TerminatorToken;
import com.singularsys.jep.configurableparser.tokens.Token;
import com.singularsys.jep.configurableparser.tokens.WhiteSpaceToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class Tokenizer {
    protected List<TokenMatcher> matchers;
    protected int currentPos = 0;
    protected String currentLine = null;
    protected int currentLineNumber = 0;
    protected BufferedReader br;
    protected List<Token> tokens;
    private static final String eol = System.getProperty("line.separator", "\n");
    private static final TerminatorToken EOF = new TerminatorToken("\u0004");

    public Tokenizer(BufferedReader bufferedReader, ConfigurableParser configurableParser) {
        this.br = bufferedReader;
        this.matchers = configurableParser.getTokenMatchers();
    }

    public List<Token> scan() throws ParseException {
        this.tokens = new ArrayList<Token>();
        while (true) {
            Token token;
            if ((token = this.nextTokenMultiLine()) == EOF) {
                if (this.tokens.isEmpty()) {
                    return null;
                }
                return this.tokens;
            }
            if (token instanceof TerminatorToken) break;
            if (token instanceof MultiLineToken) {
                token = this.readMultiLine((MultiLineToken)token);
            }
            this.tokens.add(token);
        }
        return this.tokens;
    }

    private Token nextTokenMultiLine() throws ParseException {
        if (this.currentLine == null) {
            try {
                this.currentLine = this.br.readLine();
                ++this.currentLineNumber;
            }
            catch (IOException iOException) {
                ParseException parseException = new ParseException(iOException);
                parseException.setPosition(this.currentLineNumber, this.currentPos + 1);
                throw parseException;
            }
            if (this.currentLine == null) {
                return EOF;
            }
            this.currentPos = 0;
        }
        if (this.currentPos >= this.currentLine.length()) {
            try {
                this.currentLine = this.br.readLine();
                ++this.currentLineNumber;
            }
            catch (IOException iOException) {
                ParseException parseException = new ParseException(iOException);
                parseException.setPosition(this.currentLineNumber, this.currentPos + 1);
                throw parseException;
            }
            if (this.currentLine == null) {
                return EOF;
            }
            WhiteSpaceToken whiteSpaceToken = new WhiteSpaceToken(eol);
            whiteSpaceToken.setPosition(this.currentLineNumber - 1, this.currentPos + 1);
            this.currentPos = 0;
            return whiteSpaceToken;
        }
        String string = this.currentPos == 0 ? this.currentLine : this.currentLine.substring(this.currentPos);
        Token token = this.nextToken(string);
        if (token == null) {
            ParseException parseException = new ParseException(MessageFormat.format(JepMessages.getString("configurableparser.Tokenizer.CouldNotMatchText"), string), this.currentLineNumber, this.currentPos + 1);
            throw parseException;
        }
        return token;
    }

    private Token readMultiLine(MultiLineToken multiLineToken) throws ParseException {
        Token token;
        int n = multiLineToken.getLineNumber();
        int n2 = multiLineToken.getColumnNumber();
        do {
            try {
                this.currentLine = this.br.readLine();
                ++this.currentLineNumber;
            }
            catch (IOException iOException) {
                ParseException parseException = new ParseException(iOException);
                parseException.setPosition(this.currentLineNumber, this.currentPos + 1);
                throw parseException;
            }
            if (this.currentLine != null) continue;
            throw new ParseException(JepMessages.getString("configurableparser.Tokenizer.CommentNotClosed"), this.currentLineNumber, this.currentPos + 1);
        } while ((token = multiLineToken.match(this.currentLine)) == null);
        this.currentPos = token.getLength();
        Token token2 = multiLineToken.getCompleteToken();
        token2.setPosition(n, n2);
        return token2;
    }

    private Token nextToken(String string) throws ParseException {
        if (string.length() == 0) {
            return null;
        }
        for (TokenMatcher tokenMatcher : this.matchers) {
            Token token;
            try {
                token = tokenMatcher.match(string);
            }
            catch (ParseException parseException) {
                parseException.setPosition(this.currentLineNumber, this.currentPos + 1);
                throw parseException;
            }
            if (token == null) continue;
            token.setPosition(this.currentLineNumber, this.currentPos + 1);
            this.currentPos += token.getLength();
            return token;
        }
        return null;
    }

    public static String toString(List<Token> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Token token : list) {
            stringBuilder.append(token.toString());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static class StandardTokenizerFactory
    implements TokenizerFactory {
        private static final long serialVersionUID = 340L;

        @Override
        public Tokenizer newInstance(ConfigurableParser configurableParser, BufferedReader bufferedReader) {
            return new Tokenizer(bufferedReader, configurableParser);
        }

        @Override
        public void init(Jep jep) {
        }

        @Override
        public JepComponent getLightWeightInstance() {
            return this;
        }
    }
}

