/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.configurableparser.matchers;

import com.singularsys.jep.Jep;
import com.singularsys.jep.Operator;
import com.singularsys.jep.OperatorTableI;
import com.singularsys.jep.configurableparser.TernaryOperator;
import com.singularsys.jep.configurableparser.matchers.TokenMatcher;
import com.singularsys.jep.configurableparser.tokens.OperatorToken;
import com.singularsys.jep.configurableparser.tokens.Token;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class OperatorTokenMatcher
implements TokenMatcher {
    private static final long serialVersionUID = 300L;
    private transient SortedMap<String, List<Operator>> map;
    private transient SortedMap<String, OperatorToken> tokens;

    @Override
    public void init(Jep jep) {
        this.init(jep.getOperatorTable());
    }

    public void init(OperatorTableI operatorTableI) {
        OTMComp oTMComp = new OTMComp();
        this.map = new TreeMap<String, List<Operator>>(oTMComp);
        for (Operator object : operatorTableI.getOperators()) {
            String string = object.getSymbol();
            if (object.notInParser()) continue;
            this.addSymbol(object, string);
            List<String> list = object.getAltSymbols();
            if (list != null) {
                for (String string2 : list) {
                    this.addSymbol(object, string2);
                }
            }
            if (!object.isTernary()) continue;
            String string3 = ((TernaryOperator)object).getRhsSymbol();
            this.addSymbol(((TernaryOperator)object).getRhsOperator(), string3);
        }
        this.tokens = new TreeMap<String, OperatorToken>(oTMComp);
        for (String string : this.map.keySet()) {
            this.tokens.put(string, new OperatorToken((List)this.map.get(string), string));
        }
    }

    private List<Operator> addSymbol(Operator operator, String string) {
        ArrayList<Operator> arrayList = (ArrayList<Operator>)this.map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Operator>();
        }
        arrayList.add(operator);
        this.map.put(string, arrayList);
        return arrayList;
    }

    private static boolean checkCompleteWord(String string, String string2) {
        int n = string2.length();
        if (string.length() == n) {
            return true;
        }
        if (!Character.isUnicodeIdentifierPart(string.charAt(n - 1))) {
            return true;
        }
        char c = string.charAt(n);
        return !Character.isUnicodeIdentifierPart(c);
    }

    @Override
    public Token match(String string) {
        for (Map.Entry<String, OperatorToken> entry : this.tokens.entrySet()) {
            String string2 = entry.getKey();
            if (!string.startsWith(string2) || !OperatorTokenMatcher.checkCompleteWord(string, string2)) continue;
            return entry.getValue().cloneToken();
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.map.keySet()) {
            stringBuffer.append(string + ",");
        }
        return stringBuffer.toString();
    }

    static class OTMComp
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 300L;

        OTMComp() {
        }

        @Override
        public int compare(String string, String string2) {
            int n = string2.length() - string.length();
            if (n == 0) {
                return string.compareTo(string2);
            }
            return n;
        }
    }
}

