/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.functions.UnaryFunction;
import com.singularsys.jep.reals.RealUnaryFunction;
import com.singularsys.jep.standard.Complex;

public class Abs
extends UnaryFunction
implements RealUnaryFunction {
    private static final long serialVersionUID = 300L;

    @Override
    public Object eval(Object object) throws EvaluationException {
        return this.abs(object);
    }

    public Object abs(Object object) throws EvaluationException {
        if (object instanceof Double) {
            return Math.abs((Double)object);
        }
        if (object instanceof Float) {
            return Float.valueOf(Math.abs(((Float)object).floatValue()));
        }
        if (object instanceof Integer) {
            return Math.abs((Integer)object);
        }
        if (object instanceof Long) {
            return Math.abs((Long)object);
        }
        if (object instanceof Short) {
            short s = (Short)object;
            return (int)(s >= 0 ? s : -s);
        }
        if (object instanceof Complex) {
            return ((Complex)object).abs();
        }
        throw new IllegalParameterException((PostfixMathCommand)this, 0, object);
    }

    @Override
    public double evaluate(double d) {
        return Math.abs(d);
    }
}

