/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.Add;
import com.singularsys.jep.functions.BinaryFunction;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.Multiply;
import java.text.MessageFormat;
import java.util.Vector;

public class Dot
extends BinaryFunction {
    private static final long serialVersionUID = 300L;
    protected Add add = new Add();
    protected Multiply mul = new Multiply();

    public Dot() {
        this.add.setName("+");
        this.mul.setName("*");
    }

    @Override
    public Object eval(Object object, Object object2) throws EvaluationException {
        return this.dot(object, object2);
    }

    public Object dot(Object object, Object object2) throws EvaluationException {
        if (!(object instanceof Vector)) {
            throw new IllegalParameterException((PostfixMathCommandI)this, 0, Vector.class, object);
        }
        if (!(object2 instanceof Vector)) {
            throw new IllegalParameterException((PostfixMathCommandI)this, 1, Vector.class, object2);
        }
        return this.dot((Vector)object, (Vector)object2);
    }

    public Object dot(Vector<?> vector, Vector<?> vector2) throws EvaluationException {
        if (vector.size() != vector2.size()) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.DimensionsOfVectorsDoNotMatch"), this.getName(), vector.size(), vector2.size()));
        }
        int n = vector.size();
        if (n < 1) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Dot.EmptyVectors"), this.getName()));
        }
        Object object = this.mul.mul(vector.elementAt(0), vector2.elementAt(0));
        for (int i = 1; i < n; ++i) {
            object = this.add.add(object, this.mul.mul(vector.elementAt(i), vector2.elementAt(i)));
        }
        return object;
    }
}

