/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.functions.UnaryFunction;
import com.singularsys.jep.reals.RealUnaryFunction;
import com.singularsys.jep.standard.Complex;

public class Exp
extends UnaryFunction
implements RealUnaryFunction {
    private static final long serialVersionUID = 300L;

    @Override
    public Object eval(Object object) throws EvaluationException {
        return this.exp(object);
    }

    public Object exp(Object object) throws EvaluationException {
        if (object instanceof Number) {
            return Math.exp(((Number)object).doubleValue());
        }
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            double d = complex.re();
            double d2 = complex.im();
            double d3 = Math.exp(d);
            return new Complex(d3 * Math.cos(d2), d3 * Math.sin(d2));
        }
        throw new IllegalParameterException((PostfixMathCommand)this, this.curNumberOfParameters, object);
    }

    @Override
    public double evaluate(double d) {
        return Math.exp(d);
    }
}

