/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.functions.UnaryFunction;
import com.singularsys.jep.reals.RealUnaryFunction;
import com.singularsys.jep.standard.Complex;

public class Logarithm
extends UnaryFunction
implements RealUnaryFunction {
    private static final long serialVersionUID = 300L;
    protected final boolean strict;
    static final double logE = Math.log10(Math.E);

    public Logarithm(boolean bl) {
        this.strict = bl;
    }

    public Logarithm() {
        this.strict = false;
    }

    @Override
    public Object eval(Object object) throws EvaluationException {
        return this.log(object);
    }

    public Object log(Object object) throws EvaluationException {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d >= 0.0) {
                return Math.log10(d);
            }
            if (Double.isNaN(d)) {
                return NaN;
            }
            if (this.strict) {
                return NaN;
            }
            return new Complex(Math.log10(-d), Math.PI * logE);
        }
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            return new Complex(Math.log10(complex.abs()), complex.arg() * logE);
        }
        throw new IllegalParameterException((PostfixMathCommand)this, 0, object);
    }

    @Override
    public double evaluate(double d) {
        return Math.log10(d);
    }
}

