/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.IllegalParameterException;
import java.text.MessageFormat;
import java.util.Stack;

public abstract class PostfixMathCommand
implements PostfixMathCommandI {
    private static final long serialVersionUID = 330L;
    public static final Double NaN = Double.NaN;
    protected int numberOfParameters;
    protected transient int curNumberOfParameters;
    public String name;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public PostfixMathCommand() {
        this.numberOfParameters = 0;
        this.curNumberOfParameters = 0;
    }

    public PostfixMathCommand(int n) {
        this.numberOfParameters = n;
        this.curNumberOfParameters = n;
    }

    @Override
    public int getNumberOfParameters() {
        return this.numberOfParameters;
    }

    @Override
    public void setCurNumberOfParameters(int n) {
        this.curNumberOfParameters = n;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        if (this.numberOfParameters == -1) {
            return true;
        }
        return this.numberOfParameters == n;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.RunMethodShouldNotHaveBeenCalled"), this.getName()));
    }

    protected String asString(int n, Object object) throws IllegalParameterException {
        if (!(object instanceof String)) {
            throw new IllegalParameterException((PostfixMathCommandI)this, n, String.class, object);
        }
        return (String)object;
    }

    protected int asInt(int n, Object object) throws IllegalParameterException {
        if (!(object instanceof Number)) {
            throw new IllegalParameterException((PostfixMathCommandI)this, n, Number.class, object);
        }
        return ((Number)object).intValue();
    }

    protected int asStrictInt(int n, Object object) throws IllegalParameterException {
        if (!(object instanceof Number)) {
            throw new IllegalParameterException((PostfixMathCommandI)this, n, JepMessages.getString("functions.PostfixMathCommand.AnInteger"), object);
        }
        int n2 = ((Number)object).intValue();
        double d = ((Number)object).doubleValue();
        if (d != (double)n2) {
            throw new IllegalParameterException((PostfixMathCommandI)this, n, JepMessages.getString("functions.PostfixMathCommand.AnInteger"), object);
        }
        return n2;
    }

    protected long asLong(int n, Object object) throws EvaluationException {
        if (!(object instanceof Number)) {
            throw new IllegalParameterException((PostfixMathCommandI)this, n, Number.class, object);
        }
        return ((Number)object).longValue();
    }

    protected double asDouble(int n, Object object) throws EvaluationException {
        if (!(object instanceof Number)) {
            throw new IllegalParameterException((PostfixMathCommandI)this, n, Number.class, object);
        }
        return ((Number)object).doubleValue();
    }

    protected boolean asBool(int n, Object object, boolean bl) throws EvaluationException {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (bl && object instanceof Integer) {
            return (Integer)object != 0;
        }
        if (bl && object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        if (!bl) {
            throw new IllegalParameterException((PostfixMathCommandI)this, n, Boolean.class, object);
        }
        throw new IllegalParameterException((PostfixMathCommandI)this, n, JepMessages.getString("functions.PostfixMathCommand.ABooleanOrNumber"), object);
    }

    protected Object[] asArray(Stack<Object> stack) {
        Object[] objectArray = new Object[this.curNumberOfParameters];
        for (int i = this.curNumberOfParameters - 1; i >= 0; --i) {
            objectArray[i] = stack.pop();
        }
        return objectArray;
    }

    protected String toString(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder(this.getName());
        stringBuilder.append(JepMessages.getString("functions.PostfixMathCommand.LeftBracket"));
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(JepMessages.getString("functions.PostfixMathCommand.Comma"));
            }
            if (objectArray[i] instanceof String) {
                stringBuilder.append(JepMessages.getString("functions.PostfixMathCommand.Quote"));
                stringBuilder.append(objectArray[i]);
                stringBuilder.append(JepMessages.getString("functions.PostfixMathCommand.Quote"));
                continue;
            }
            stringBuilder.append(objectArray[i]);
        }
        stringBuilder.append(JepMessages.getString("functions.PostfixMathCommand.RightBracket"));
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getName();
    }
}

